package Device::USB::DevInterface;

require 5.006;
use warnings;
use strict;
use Carp;


our $VERSION=0.36;


sub _make_descr_accessor
{
    my $name = shift;
    ## no critic (ProhibitStringyEval)

    return eval <<"EOE";
sub $name
        {
            my \$self = shift;
            return \$self->{$name};
        }
EOE
}


_make_descr_accessor( 'bInterfaceNumber' );
_make_descr_accessor( 'bAlternateSetting' );
_make_descr_accessor( 'bNumEndpoints' );
_make_descr_accessor( 'bInterfaceClass' );
_make_descr_accessor( 'bInterfaceSubClass' );
_make_descr_accessor( 'bInterfaceProtocol' );
_make_descr_accessor( 'iInterface' );


sub endpoints
{
    my $self = shift;
    return wantarray ? @{$self->{endpoints}} : $self->{endpoints};
}


1;
