package Device::USB::DevEndpoint;

require 5.006;
use warnings;
use strict;
use Carp;


our $VERSION=0.36;


sub _make_descr_accessor
{
    my $name = shift;
    ## no critic (ProhibitStringyEval)

    return eval <<"EOE";
sub $name
        {
            my \$self = shift;
            return \$self->{$name};
        }
EOE
}


_make_descr_accessor( 'bEndpointAddress' );
_make_descr_accessor( 'bmAttributes' );
_make_descr_accessor( 'wMaxPacketSize' );
_make_descr_accessor( 'bInterval' );
_make_descr_accessor( 'bRefresh' );
_make_descr_accessor( 'bSynchAddress' );


1;
