package Device::USB::DevConfig;

require 5.006;
use warnings;
use strict;
use Carp;


our $VERSION=0.36;


sub _make_descr_accessor
{
    my $name = shift;
    ## no critic (ProhibitStringyEval)

    return eval <<"EOE";
sub $name
        {
            my \$self = shift;
            return \$self->{$name};
        }
EOE
}


sub interfaces
{
    my $self = shift;
    return wantarray ? @{$self->{interfaces}} : $self->{interfaces};
}


_make_descr_accessor( 'wTotalLength' );
_make_descr_accessor( 'bNumInterfaces' );
_make_descr_accessor( 'bConfigurationValue' );
_make_descr_accessor( 'iConfiguration' );
_make_descr_accessor( 'bmAttributes' );
_make_descr_accessor( 'MaxPower' );



1;
