package Device::USB::Bus;

require 5.006;
use warnings;
use strict;
use Carp;


our $VERSION=0.36;


sub dirname
{
    my $self = shift;

    return $self->{dirname};
}


sub location
{
    my $self = shift;

    return $self->{location};
}


sub devices
{
    my $self = shift;

    return wantarray ? @{$self->{devices}} : $self->{devices};
}


sub find_device_if
{
    my $self = shift;
    my $pred = shift;

    croak( "Missing predicate for choosing a device.\n" )
        unless defined $pred;

    croak( "Predicate must be a code reference.\n" )
        unless 'CODE' eq ref $pred;

    local $_ = undef;

    foreach($self->devices())
    {
        return $_ if $pred->();
    }

    return;
}


sub list_devices_if
{
    my $self = shift;
    my $pred = shift;

    croak( "Missing predicate for choosing devices.\n" )
        unless defined $pred;

    croak( "Predicate must be a code reference.\n" )
        unless 'CODE' eq ref $pred;

    local $_ = undef;

    my @devices = grep { $pred->() } $self->devices();

    return wantarray ? @devices : \@devices;
}


1;
