
function parseMarkdown(markdown){const lines=markdown.split('\n');const html=[];let inList=false;let listType='';lines.forEach((line)=>{let trimmedLine=line.trim();if(trimmedLine===''){if(inList){html.push(`</${listType}>`);inList=false;listType='';}
return;}
if(/^###\s+(.*)/.test(trimmedLine)){const content=trimmedLine.replace(/^###\s+/,'');html.push(`<h3>${escapeHtml(content)}</h3>`);return;}else if(/^##\s+(.*)/.test(trimmedLine)){const content=trimmedLine.replace(/^##\s+/,'');html.push(`<h2>${escapeHtml(content)}</h2>`);return;}else if(/^#\s+(.*)/.test(trimmedLine)){const content=trimmedLine.replace(/^#\s+/,'');html.push(`<h1>${escapeHtml(content)}</h1>`);return;}
let orderedMatch=trimmedLine.match(/^(\d+)\.\s+(.*)/);if(orderedMatch){const[,number,content]=orderedMatch;if(!inList||listType!=='ol'){if(inList){html.push(`</${listType}>`);}
html.push('<ol>');inList=true;listType='ol';}
html.push(`<li>${parseInlineMarkdown(escapeHtml(content))}</li>`);return;}
let unorderedMatch=trimmedLine.match(/^[-*]\s+(.*)/);if(unorderedMatch){const content=unorderedMatch[1];if(!inList||listType!=='ul'){if(inList){html.push(`</${listType}>`);}
html.push('<ul>');inList=true;listType='ul';}
html.push(`<li>${parseInlineMarkdown(escapeHtml(content))}</li>`);return;}
if(inList){html.push(`</${listType}>`);inList=false;listType='';}
html.push(`<p>${parseInlineMarkdown(escapeHtml(trimmedLine))}</p>`);});if(inList){html.push(`</${listType}>`);}
return html.join('\n');}
function parseInlineMarkdown(text){return text.replace(/\*\*(.+?)\*\*/g,'<strong>$1</strong>').replace(/__(.+?)__/g,'<strong>$1</strong>');}
function escapeHtml(text){const map={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;',};return text.replace(/[&<>"']/g,function(m){return map[m];});}
return L.Class.extend({parseMarkdown:parseMarkdown,});