class Xsd < Formula
  desc "XML Data Binding for C++"
  homepage "https://www.codesynthesis.com/products/xsd/"
  url "https://www.codesynthesis.com/download/xsd/4.2/xsd-4.2.0.tar.gz"
  sha256 "2bed17c601cfb984f9a7501fd5c672f4f18eac678f5bdef6016971966add9145"
  license "GPL-2.0-only" => { with: "Classpath-exception-2.0" }

  livecheck do
    url "https://www.codesynthesis.com/products/xsd/download.xhtml"
    regex(/href=.*?xsd[._-]v?(\d+(?:\.\d+)+)\.t/i)
  end

  depends_on "build2" => :build
  depends_on "libcutl"
  depends_on "libxsd-frontend"
  depends_on "xerces-c"

  conflicts_with "mono", because: "both install `xsd` binaries"

  resource "libxsd" do
    url "https://www.codesynthesis.com/download/xsd/4.2/libxsd-4.2.0.tar.gz"
    sha256 "55caf0038603883eb39ac4caeaacda23a09cf81cffc8eb55a854b6b06ef2c52e"

    livecheck do
      formula :parent
    end
  end

  def install
    odie "`libxsd` resource needs to be updated!" if version != resource("libxsd").version

    system "b", "configure", "config.cc.loptions=-L#{HOMEBREW_PREFIX}/lib", "config.install.root=#{prefix}"
    system "b", "install", "--jobs=#{ENV.make_jobs}", "-V"

    resource("libxsd").stage do
      system "b", "configure", "config.install.root=#{prefix}"
      system "b", "install", "--jobs=#{ENV.make_jobs}", "-V"
    end
  end

  test do
    (testpath/"meaningoflife.xsd").write <<~XSD
      <?xml version="1.0" encoding="UTF-8"?>
      <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"
                 targetNamespace="https://brew.sh/XSDTest" xmlns="https://brew.sh/XSDTest">
        <xs:element name="MeaningOfLife" type="xs:positiveInteger"/>
      </xs:schema>
    XSD

    (testpath/"meaningoflife.xml").write <<~XML
      <?xml version="1.0" encoding="UTF-8"?>
      <MeaningOfLife xmlns="https://brew.sh/XSDTest" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                     xsi:schemaLocation="https://brew.sh/XSDTest meaningoflife.xsd">
        42
      </MeaningOfLife>
    XML

    (testpath/"xsdtest.cxx").write <<~CPP
      #include <cassert>
      #include "meaningoflife.hxx"
      int main (int argc, char *argv[]) {
        assert(2==argc);
        std::unique_ptr<::xml_schema::positive_integer> x = XSDTest::MeaningOfLife(argv[1]);
        assert(42==*x);
        return 0;
      }
    CPP

    system bin/"xsd", "cxx-tree", "meaningoflife.xsd"
    assert_path_exists testpath/"meaningoflife.hxx"
    assert_path_exists testpath/"meaningoflife.cxx"

    system ENV.cxx, "-std=c++11", "xsdtest.cxx", "meaningoflife.cxx", "-o", "xsdtest",
                    "-L#{Formula["xerces-c"].opt_lib}", "-lxerces-c"
    system "./xsdtest", "meaningoflife.xml"
  end
end
