[![Build CI](https://img.shields.io/github/actions/workflow/status/finos/OpenMAMA/main.yml?label=Build%20CI)](https://github.com/finos/openmama/actions/workflows/main.yml)
[![FINOS - Active](https://cdn.jsdelivr.net/gh/finos/contrib-toolbox@master/images/badge-active.svg)](https://finosfoundation.atlassian.net/wiki/display/FINOS/Active)
[![License](https://img.shields.io/badge/License-LGPLv2.1-blue.svg)](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html)
[![OpenSSF Best Practices](https://bestpractices.coreinfrastructure.org/projects/6741/badge)](https://bestpractices.coreinfrastructure.org/projects/6741) 
[![Join the chat at https://gitter.im/OpenMAMA/OpenMAMA](https://badges.gitter.im/OpenMAMA/OpenMAMA.svg)](https://gitter.im/OpenMAMA/OpenMAMA?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
[![.NET security](https://img.shields.io/github/actions/workflow/status/finos/OpenMAMA/cve-scanning-dotnet.yml?label=.NET%20Security)](https://github.com/finos/openmama/actions/workflows/cve-scanning-dotnet.yml)
[![Java Security](https://img.shields.io/github/actions/workflow/status/finos/OpenMAMA/cve-scanning-gradle.yml?label=Java%20Security)](https://github.com/finos/openmama/actions/workflows/cve-scanning-gradle.yml)
[![Docker Security](https://img.shields.io/github/actions/workflow/status/finos/OpenMAMA/cve-scanning-docker.yml?label=Docker%20Security)](https://github.com/finos/openmama/actions/workflows/cve-scanning-docker.yml)
[![Static Code Analysis](https://img.shields.io/github/actions/workflow/status/finos/OpenMAMA/semgrep.yml?label=Static%20Code%20Analysis)](https://github.com/finos/openmama/actions/workflows/semgrep.yml)

The Open Middleware Agnostic Messaging API
================================================================================

OpenMAMA is a high performance vendor neutral lightweight wrapper that provides a common API interface
to different middleware and messaging solutions across a variety of platforms and languages.

OpenMAMDA is a framework that adds Market Data functionality, such as order book handling on top of MAMA.

The [project's homepage](https://openmama.finos.org) provides a good overview of the project along with how to get in touch.

If you're in a pinch, you can also pop into [our gitter channel](https://gitter.im/OpenMAMA/OpenMAMA) to have a chat if you just want quick answers.

## Governance

OpenMAMA was accepted as a project under the auspices of [FINOS](finos.org), the Fintech Open Source Foundation in October 2020.
The [OpenMAMA's project charter](https://github.com/finos/OpenMAMA/raw/next/OpenMAMA%20Technical%20Charter%202020-10-01.pdf) was approved by the [FINOS Governing Board](https://www.finos.org/governing-board) on October 21, 2020.

Supported Platforms
--------------------------------------------------------------------------------
Currently C, C++, C# and Java are all supported languages and Linux and Windows are supported platforms.

You can find more details on supported platforms [here](https://openmama.finos.org/openmama_supported_platforms.html)

Docker
--------------------------------------------------------------------------------
For docker support for OpenMAMA, please see [our docker guide](docker/README.md).

Downloading the Software
--------------------------------------------------------------------------------
You can find the latest stable releases [on the our github releases page](https://github.com/finos/OpenMAMA/releases)
or alternatively you can check out our
[cloudsmith repositories](https://cloudsmith.io/~openmama/repos/openmama/setup/)
which can provide stable or unstable builds depending on which repository you select.

Getting Started
--------------------------------------------------------------------------------
If you want to dive in, take a look at [our quick start guide](https://openmama.finos.org/quickstart.html)

Documentation
--------------------------------------------------------------------------------
We host the latest OpenMAMA Technical documentation on [https://openmama.finos.org/documentation.html](https://openmama.finos.org/documentation.html)

Licensing
--------------------------------------------------------------------------------
This software is licensed under LGPL 2.1. Full terms are included in the `LICENSE.md` file. This software also
depends on several third party libraries, the licenses for which are listed in the `LICENSE-3RD-PARTY.txt` file.

Contributing
--------------------------------------------------------------------------------
Information on contributing on the project can be found [here](https://openmama.finos.org/openmama_submission_process.html).

