# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_ferium_global_optspecs
	string join \n t/threads= github-token= curseforge-api-key= c/config-file= h/help V/version
end

function __fish_ferium_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_ferium_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_ferium_using_subcommand
	set -l cmd (__fish_ferium_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c ferium -n "__fish_ferium_needs_command" -s t -l threads -d 'Sets the number of worker threads the tokio runtime will use. You can also use the environment variable `TOKIO_WORKER_THREADS`' -r
complete -c ferium -n "__fish_ferium_needs_command" -l github-token -l gh -d 'Set a GitHub personal access token for increasing the GitHub API rate limit. You can also use the environment variable `GITHUB_TOKEN`' -r
complete -c ferium -n "__fish_ferium_needs_command" -l curseforge-api-key -l cf -d 'Set a custom Curseforge API key. You can also use the environment variable `CURSEFORGE_API_KEY`' -r
complete -c ferium -n "__fish_ferium_needs_command" -s c -l config-file -l config -l conf -d 'Set the file to read the config from. This does not change the `cache` and `tmp` directories. You can also use the environment variable `FERIUM_CONFIG_FILE`' -r -F
complete -c ferium -n "__fish_ferium_needs_command" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_needs_command" -s V -l version -d 'Print version'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "add" -d 'Add mods to the profile'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "scan" -d 'Scan the profile\'s output directory (or the specified directory) for mods and add them to the profile'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "complete" -d 'Print shell auto completions for the specified shell'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "list" -d 'List all the mods in the profile, and with some their metadata if verbose'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "mods" -d 'List all the mods in the profile, and with some their metadata if verbose'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "modpack" -d 'Add, configure, delete, switch, list, or upgrade modpacks'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "modpacks" -d 'List all the modpacks with their data'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "profile" -d 'Create, configure, delete, switch, or list profiles'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "profiles" -d 'List all the profiles with their data'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "remove" -d 'Remove mods and/or repositories from the profile. Optionally, provide a list of names or IDs of the mods to remove'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "rm" -d 'Remove mods and/or repositories from the profile. Optionally, provide a list of names or IDs of the mods to remove'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "upgrade" -d 'Download and install the latest compatible version of your mods'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "download" -d 'Download and install the latest compatible version of your mods'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "install" -d 'Download and install the latest compatible version of your mods'
complete -c ferium -n "__fish_ferium_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ferium -n "__fish_ferium_using_subcommand add" -s f -l force -l override -d 'Temporarily ignore game version and mod loader checks and add the mod anyway'
complete -c ferium -n "__fish_ferium_using_subcommand add" -s V -l ignore-game-version -d 'The game version will not be checked for this mod. Only works when adding a single mod'
complete -c ferium -n "__fish_ferium_using_subcommand add" -s M -l ignore-mod-loader -d 'The mod loader will not be checked for this mod. Only works when adding a single mod'
complete -c ferium -n "__fish_ferium_using_subcommand add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c ferium -n "__fish_ferium_using_subcommand scan" -s p -l platform -d 'The platform you prefer mods to be added from. If a mod isn\'t available from this platform, the other platform will still be used' -r -f -a "{modrinth\t'',curseforge\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand scan" -s d -l directory -l dir -l folder -d 'The directory to scan mods from. Defaults to the profile\'s output directory' -r -F
complete -c ferium -n "__fish_ferium_using_subcommand scan" -s f -l force -l override -d 'Temporarily ignore game version and mod loader checks and add the mods anyway'
complete -c ferium -n "__fish_ferium_using_subcommand scan" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand complete" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand list" -s v -l verbose -d 'Show additional information about the mod'
complete -c ferium -n "__fish_ferium_using_subcommand list" -s m -l markdown -l md -d 'Output information in markdown format and alphabetical order'
complete -c ferium -n "__fish_ferium_using_subcommand list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c ferium -n "__fish_ferium_using_subcommand mods" -s v -l verbose -d 'Show additional information about the mod'
complete -c ferium -n "__fish_ferium_using_subcommand mods" -s m -l markdown -l md -d 'Output information in markdown format and alphabetical order'
complete -c ferium -n "__fish_ferium_using_subcommand mods" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "add" -d 'Add a modpack to the config'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "configure" -d 'Configure the current modpack\'s output directory and installation of overrides. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "config" -d 'Configure the current modpack\'s output directory and installation of overrides. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "conf" -d 'Configure the current modpack\'s output directory and installation of overrides. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "delete" -d 'Delete a modpack. Optionally, provide the name of the modpack to delete'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "remove" -d 'Delete a modpack. Optionally, provide the name of the modpack to delete'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "rm" -d 'Delete a modpack. Optionally, provide the name of the modpack to delete'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "info" -d 'Show information about the current modpack'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "list" -d 'List all the modpacks with their data'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "switch" -d 'Switch between different modpacks. Optionally, provide the name of the modpack to switch to'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "upgrade" -d 'Download and install the latest version of the modpack'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "download" -d 'Download and install the latest version of the modpack'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "install" -d 'Download and install the latest version of the modpack'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and not __fish_seen_subcommand_from add configure config conf delete remove rm info list switch upgrade download install help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from add" -s o -l output-dir -d 'The Minecraft instance directory to install the modpack to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from add" -s i -l install-overrides -d 'Whether to install the modpack\'s overrides to the output directory. This will override existing files when upgrading' -r -f -a "{true\t'',false\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from configure" -s o -l output-dir -d 'The Minecraft instance directory to install the modpack to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from configure" -s i -l install-overrides -d 'Whether to install the modpack\'s overrides to the output directory. This will override existing files when upgrading' -r -f -a "{true\t'',false\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from configure" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from config" -s o -l output-dir -d 'The Minecraft instance directory to install the modpack to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from config" -s i -l install-overrides -d 'Whether to install the modpack\'s overrides to the output directory. This will override existing files when upgrading' -r -f -a "{true\t'',false\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from config" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from conf" -s o -l output-dir -d 'The Minecraft instance directory to install the modpack to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from conf" -s i -l install-overrides -d 'Whether to install the modpack\'s overrides to the output directory. This will override existing files when upgrading' -r -f -a "{true\t'',false\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from conf" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from delete" -s s -l switch-to -d 'The name of the profile to switch to afterwards' -r
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from remove" -s s -l switch-to -d 'The name of the profile to switch to afterwards' -r
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from rm" -s s -l switch-to -d 'The name of the profile to switch to afterwards' -r
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from rm" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from switch" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from upgrade" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from download" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from install" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add a modpack to the config'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "configure" -d 'Configure the current modpack\'s output directory and installation of overrides. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a modpack. Optionally, provide the name of the modpack to delete'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "info" -d 'Show information about the current modpack'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all the modpacks with their data'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "switch" -d 'Switch between different modpacks. Optionally, provide the name of the modpack to switch to'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "upgrade" -d 'Download and install the latest version of the modpack'
complete -c ferium -n "__fish_ferium_using_subcommand modpack; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ferium -n "__fish_ferium_using_subcommand modpacks" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "configure" -d 'Configure the current profile\'s name, Minecraft version, mod loader, and output directory. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "config" -d 'Configure the current profile\'s name, Minecraft version, mod loader, and output directory. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "conf" -d 'Configure the current profile\'s name, Minecraft version, mod loader, and output directory. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "create" -d 'Create a new profile. Optionally, provide the settings as arguments. Use the import flag to import mods from another profile'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "new" -d 'Create a new profile. Optionally, provide the settings as arguments. Use the import flag to import mods from another profile'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "delete" -d 'Delete a profile. Optionally, provide the name of the profile to delete'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "remove" -d 'Delete a profile. Optionally, provide the name of the profile to delete'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "rm" -d 'Delete a profile. Optionally, provide the name of the profile to delete'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "info" -d 'Show information about the current profile'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "list" -d 'List all the profiles with their data'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "switch" -d 'Switch between different profiles. Optionally, provide the name of the profile to switch to'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and not __fish_seen_subcommand_from configure config conf create new delete remove rm info list switch help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from configure" -s v -l game-version -d 'The Minecraft version to check compatibility for' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from configure" -s m -l mod-loader -d 'The mod loader to check compatibility for' -r -f -a "{quilt\t'',fabric\t'',forge\t'',neo-forge\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from configure" -s n -l name -d 'The name of the profile' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from configure" -s o -l output-dir -d 'The directory to output mods to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from configure" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from config" -s v -l game-version -d 'The Minecraft version to check compatibility for' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from config" -s m -l mod-loader -d 'The mod loader to check compatibility for' -r -f -a "{quilt\t'',fabric\t'',forge\t'',neo-forge\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from config" -s n -l name -d 'The name of the profile' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from config" -s o -l output-dir -d 'The directory to output mods to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from config" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from conf" -s v -l game-version -d 'The Minecraft version to check compatibility for' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from conf" -s m -l mod-loader -d 'The mod loader to check compatibility for' -r -f -a "{quilt\t'',fabric\t'',forge\t'',neo-forge\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from conf" -s n -l name -d 'The name of the profile' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from conf" -s o -l output-dir -d 'The directory to output mods to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from conf" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from create" -s i -l import -l copy -l duplicate -d 'Copy over the mods from an existing profile. Optionally, provide the name of the profile to import mods from' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from create" -s v -l game-version -d 'The Minecraft version to check compatibility for' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from create" -s m -l mod-loader -d 'The mod loader to check compatibility for' -r -f -a "{quilt\t'',fabric\t'',forge\t'',neo-forge\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from create" -s n -l name -d 'The name of the profile' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from create" -s o -l output-dir -d 'The directory to output mods to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from new" -s i -l import -l copy -l duplicate -d 'Copy over the mods from an existing profile. Optionally, provide the name of the profile to import mods from' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from new" -s v -l game-version -d 'The Minecraft version to check compatibility for' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from new" -s m -l mod-loader -d 'The mod loader to check compatibility for' -r -f -a "{quilt\t'',fabric\t'',forge\t'',neo-forge\t''}"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from new" -s n -l name -d 'The name of the profile' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from new" -s o -l output-dir -d 'The directory to output mods to' -r -f -a "(__fish_complete_directories)"
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from delete" -s s -l switch-to -d 'The name of the profile to switch to afterwards' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from remove" -s s -l switch-to -d 'The name of the profile to switch to afterwards' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from rm" -s s -l switch-to -d 'The name of the profile to switch to afterwards' -r
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from rm" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from switch" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "configure" -d 'Configure the current profile\'s name, Minecraft version, mod loader, and output directory. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new profile. Optionally, provide the settings as arguments. Use the import flag to import mods from another profile'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a profile. Optionally, provide the name of the profile to delete'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "info" -d 'Show information about the current profile'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all the profiles with their data'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "switch" -d 'Switch between different profiles. Optionally, provide the name of the profile to switch to'
complete -c ferium -n "__fish_ferium_using_subcommand profile; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ferium -n "__fish_ferium_using_subcommand profiles" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand remove" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand rm" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand upgrade" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand download" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand install" -s h -l help -d 'Print help'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "add" -d 'Add mods to the profile'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "scan" -d 'Scan the profile\'s output directory (or the specified directory) for mods and add them to the profile'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "complete" -d 'Print shell auto completions for the specified shell'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "list" -d 'List all the mods in the profile, and with some their metadata if verbose'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "modpack" -d 'Add, configure, delete, switch, list, or upgrade modpacks'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "modpacks" -d 'List all the modpacks with their data'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "profile" -d 'Create, configure, delete, switch, or list profiles'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "profiles" -d 'List all the profiles with their data'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "remove" -d 'Remove mods and/or repositories from the profile. Optionally, provide a list of names or IDs of the mods to remove'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "upgrade" -d 'Download and install the latest compatible version of your mods'
complete -c ferium -n "__fish_ferium_using_subcommand help; and not __fish_seen_subcommand_from add scan complete list modpack modpacks profile profiles remove upgrade help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from modpack" -f -a "add" -d 'Add a modpack to the config'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from modpack" -f -a "configure" -d 'Configure the current modpack\'s output directory and installation of overrides. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from modpack" -f -a "delete" -d 'Delete a modpack. Optionally, provide the name of the modpack to delete'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from modpack" -f -a "info" -d 'Show information about the current modpack'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from modpack" -f -a "list" -d 'List all the modpacks with their data'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from modpack" -f -a "switch" -d 'Switch between different modpacks. Optionally, provide the name of the modpack to switch to'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from modpack" -f -a "upgrade" -d 'Download and install the latest version of the modpack'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "configure" -d 'Configure the current profile\'s name, Minecraft version, mod loader, and output directory. Optionally, provide the settings to change as arguments'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "create" -d 'Create a new profile. Optionally, provide the settings as arguments. Use the import flag to import mods from another profile'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "delete" -d 'Delete a profile. Optionally, provide the name of the profile to delete'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "info" -d 'Show information about the current profile'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "list" -d 'List all the profiles with their data'
complete -c ferium -n "__fish_ferium_using_subcommand help; and __fish_seen_subcommand_from profile" -f -a "switch" -d 'Switch between different profiles. Optionally, provide the name of the profile to switch to'
