class Dcled < Formula
  desc "Linux driver for dream cheeky USB message board"
  homepage "https://www.jeffrika.com/~malakai/dcled/index.html"
  url "https://www.jeffrika.com/~malakai/dcled/dcled-2.2.tgz"
  sha256 "0da78c04e1aa42d16fa3df985cf54b0fbadf2d8ff338b9bf59bfe103c2a959c6"
  license :cannot_represent

  livecheck do
    url :homepage
    regex(/href=.*?dcled[._-]v?(\d+(?:\.\d+)+)\.t/i)
  end

  depends_on "libusb"

  def install
    # Fix compile with newer Clang
    if DevelopmentTools.clang_build_version >= 1403
      inreplace "Makefile", "-Wunused-variable", "-Wunused-variable -Wno-implicit-function-declaration"
    end

    system "make", "CC=#{ENV.cc}",
                   "LIBUSB_CFLAGS=-I#{Formula["libusb"].opt_include}/libusb-1.0"
    system "make", "install",
                   "FONTDIR=#{share}/#{name}",
                   "INSTALLDIR=#{bin}"
  end

  test do
    system bin/"dcled", "--help"
  end
end
