# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_comtrya_global_optspecs
	string join \n d/manifest-directory= c/config-path= no-color D/defines= v h/help V/version
end

function __fish_comtrya_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_comtrya_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_comtrya_using_subcommand
	set -l cmd (__fish_comtrya_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c comtrya -n "__fish_comtrya_needs_command" -s d -l manifest-directory -r
complete -c comtrya -n "__fish_comtrya_needs_command" -s c -l config-path -d 'Specify a configuration path (if invalid Comtrya will exit)' -r
complete -c comtrya -n "__fish_comtrya_needs_command" -s D -l defines -r
complete -c comtrya -n "__fish_comtrya_needs_command" -l no-color -d 'Disable color printing'
complete -c comtrya -n "__fish_comtrya_needs_command" -s v -d 'Debug & tracing mode (-v, -vv)'
complete -c comtrya -n "__fish_comtrya_needs_command" -s h -l help -d 'Print help'
complete -c comtrya -n "__fish_comtrya_needs_command" -s V -l version -d 'Print version'
complete -c comtrya -n "__fish_comtrya_needs_command" -f -a "apply" -d 'Apply manifests'
complete -c comtrya -n "__fish_comtrya_needs_command" -f -a "status" -d 'List manifests status (ALPHA)'
complete -c comtrya -n "__fish_comtrya_needs_command" -f -a "version" -d 'Print version information'
complete -c comtrya -n "__fish_comtrya_needs_command" -f -a "contexts" -d 'List available contexts'
complete -c comtrya -n "__fish_comtrya_needs_command" -f -a "gen-completions" -d 'Auto generate completions'
complete -c comtrya -n "__fish_comtrya_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c comtrya -n "__fish_comtrya_using_subcommand apply" -s m -l manifests -d 'Run a subset of your manifests, comma separated list. This should be a list of manifest names. No paths' -r
complete -c comtrya -n "__fish_comtrya_using_subcommand apply" -s l -l label -d 'Define label selector' -r
complete -c comtrya -n "__fish_comtrya_using_subcommand apply" -l dry-run -d 'Performs a dry-run without changing the system'
complete -c comtrya -n "__fish_comtrya_using_subcommand apply" -s h -l help -d 'Print help'
complete -c comtrya -n "__fish_comtrya_using_subcommand status" -s m -l manifests -d 'Run a subset of your manifests, comma separated list. This should be a list of manifest names. No paths' -r
complete -c comtrya -n "__fish_comtrya_using_subcommand status" -s l -l label -d 'Define label selector' -r
complete -c comtrya -n "__fish_comtrya_using_subcommand status" -l dry-run -d 'Performs a dry-run without changing the system'
complete -c comtrya -n "__fish_comtrya_using_subcommand status" -s h -l help -d 'Print help'
complete -c comtrya -n "__fish_comtrya_using_subcommand version" -s h -l help -d 'Print help'
complete -c comtrya -n "__fish_comtrya_using_subcommand contexts" -l show-values -d 'Show the values of the contexts'
complete -c comtrya -n "__fish_comtrya_using_subcommand contexts" -s h -l help -d 'Print help'
complete -c comtrya -n "__fish_comtrya_using_subcommand gen-completions" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c comtrya -n "__fish_comtrya_using_subcommand help; and not __fish_seen_subcommand_from apply status version contexts gen-completions help" -f -a "apply" -d 'Apply manifests'
complete -c comtrya -n "__fish_comtrya_using_subcommand help; and not __fish_seen_subcommand_from apply status version contexts gen-completions help" -f -a "status" -d 'List manifests status (ALPHA)'
complete -c comtrya -n "__fish_comtrya_using_subcommand help; and not __fish_seen_subcommand_from apply status version contexts gen-completions help" -f -a "version" -d 'Print version information'
complete -c comtrya -n "__fish_comtrya_using_subcommand help; and not __fish_seen_subcommand_from apply status version contexts gen-completions help" -f -a "contexts" -d 'List available contexts'
complete -c comtrya -n "__fish_comtrya_using_subcommand help; and not __fish_seen_subcommand_from apply status version contexts gen-completions help" -f -a "gen-completions" -d 'Auto generate completions'
complete -c comtrya -n "__fish_comtrya_using_subcommand help; and not __fish_seen_subcommand_from apply status version contexts gen-completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
