# cargo-deps

[![Build Status](https://img.shields.io/github/actions/workflow/status/mrcnski/cargo-deps/ci.yml?style=flat-square)](https://github.com/mrcnski/cargo-deps/actions/workflows/ci.yml)
[![crates.io](https://img.shields.io/crates/v/cargo-deps.svg)](https://crates.io/crates/cargo-deps)
[![Documentation](https://docs.rs/cargo-deps/badge.svg)](https://docs.rs/cargo-deps)
[![unsafe forbidden](https://img.shields.io/badge/unsafe-forbidden-success.svg)](https://github.com/rust-secure-code/safety-dance/)
[![Downloads](https://img.shields.io/crates/d/cargo-deps.svg)](https://crates.io/crates/cargo-deps)
[![Issues](https://img.shields.io/github/issues-raw/mrcnski/cargo-deps.svg)](https://github.com/mrcnski/cargo-deps/issues)
[![LoC](https://tokei.rs/b1/github/mrcnski/cargo-deps)](https://github.com/mrcnski/cargo-deps)
[![Coverage Status](https://coveralls.io/repos/github/mrcnski/cargo-deps/badge.svg?branch=master)](https://coveralls.io/github/mrcnski/cargo-deps?branch=master)
[![License: BSD-3-Clause](https://img.shields.io/badge/license-BSD--3--Clause-blue.svg)](https://opensource.org/license/bsd-3-clause/)

**Note:** This crate is not actively worked on. Consider using one of the crates mentioned in [Alternatives](#alternatives).

<details>
<summary>Table of Contents</summary>
<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-refresh-toc -->
**Table of Contents**

- [cargo-deps](#cargo-deps)
    - [About](#about)
    - [Installing](#installing)
    - [Instructions](#instructions)
        - [Dependency Kinds](#dependency-kinds)
        - [Filtering](#filtering)
            - [Excluding](#excluding)
            - [Depth](#depth)
            - [Filtering transitive edges](#filtering-transitive-edges)
        - [Subgraphs](#subgraphs)
        - [Examples](#examples)
        - [More info](#more-info)
    - [Alternatives](#alternatives)
    - [License](#license)
    - [Dependencies](#dependencies)
    - [Changelog](#changelog)

<!-- markdown-toc end -->
</details>

## About

Cargo subcommand for building dependency graphs of Rust projects.

This project is an improvement on the unmaintained and buggy [cargo-graph](https://github.com/kbknapp/cargo-graph).

**Example:**

![safe_app dependencies](safe-client-libs.png)

## Installing

`cargo-deps` can be installed with `cargo install`:

```
cargo install cargo-deps
```

## Instructions

First, make sure you have [graphviz](https://graphviz.gitlab.io/download/) installed.

Next, just `cd` into the Rust project directory you want to graph and run:

```
cargo deps | dot -Tpng > graph.png
```

That's it! `graph.png` will contain the graph (you can change its name, of course!)

Note that `>` may not work if the output file already exists, in which case you can try `>|`.

### Dependency Kinds

The default behavior is to exclude optional, dev, and build dependencies. To see all dependencies, pass `--all-deps`:

```
cargo deps --all-deps | dot -Tpng > graph.png
```

Dependencies are colored depending on their kind:

* **Black:** regular dependency
* **Purple:** build dependency
* **Blue:** dev dependency
* **Red:** optional dependency

A dependency can be of more than one kind. In such cases, it is colored with the following priority:

```
Regular -> Build -> Dev -> Optional
```

For example, if a dependency is both a build and a dev dependency, then it will be colored as a build dependency. If, however, you pass the `--dev-deps` option instead of `--all-deps`, the dependency will be colored as a dev dependency (as the build-dependency graph will not be shown).

### Filtering

Some Rust projects have really big dependency trees and maybe you just want to display certain dependencies, like the ones in the same workspace. Fortunately, `cargo-deps` provides the `--filter` option for this use case. Unfortunately, you have to explicitly list all the dependencies you want to keep, and `cargo-deps` doesn't detect workspaces just yet.

#### Excluding

It can be useful to exclude certain crates from the final graph. This can be achieved with the `--exclude` flag taking the undesired crates as arguments.

#### Depth

In order to constrain the size of graphs and make them cleaner, it is possible to limit the output to dependencies within a certain depth using the `--depth` option.

#### Filtering transitive edges

For large dependency graphs, the `--no-transitive-deps` option can be used to filter out edges that are "covered" by a transitive dependency, which can make visual parsing a little easier by omitting some redundant edges. For example, if crate `A` depends directly on crate `B` and `C`, and crate `B` depends directly on crate `C`, this option would omit the edge from `A` to `C`. To illustrate, compare the [default dependency graph](tokei-default.png) for Tokei, generated by `cargo deps`, to the [graph with transitive edges removed](tokei-transitive.png), generated by `cargo deps --no-transitive-deps`.

### Subgraphs

You can visually group a set of dependencies by using the `--subgraph` command.

### Examples

**[Tokei](https://github.com/Aaronepower/tokei)** -- [graph](tokei.png)

This was generated using the command:

```
cargo deps -I --all-deps --no-regular-deps | dot -Tpng > tokei.png
```

**[SAFE Client Libs](https://github.com/maidsafe/safe_client_libs)** -- [graph](safe-client-libs.png)

This was generated using the following whopper of a command to display only MaidSafe dependencies:

```
cargo deps --all-deps --include-orphans --subgraph safe_app safe_app_jni safe_authenticator safe_authenticator_jni safe_core --subgraph-name "SAFE Client Libs" --filter accumulator config_file_handler crust ffi_utils fake_clock lru_time_cache maidsafe_utilities parsec resource_proof routing rust_sodium safe_app safe_app_jni safe_authenticator safe_authenticator_jni safe_bindgen safe_core safe_crypto safe_vault secure_serialisation self_encryption system_uri tokio_utp --manifest-path safe_app/Cargo.toml | dot -Tpng -Nfontname=Iosevka -Gfontname=Iosevka > safe-client-libs.png
```

### More info

Run `cargo deps -h` to see all available options.

## Alternatives

While `cargo-deps` should work for most use cases, it has an outdated architecture and the creator is not working on active development. Some alternatives to consider are:

- [`cargo-depgraph`](https://sr.ht/~jplatte/cargo-depgraph/): Has more features than `cargo-deps`.
- [`cargo-tree`](https://doc.rust-lang.org/cargo/commands/cargo-tree.html): Displays dependencies in a textual format. As of Rust 1.44 is included in `cargo` as a subcommand.

## Dependencies

![cargo-deps dependencies](cargo-deps.png)

## Changelog

[Changelog](CHANGELOG.md)
