# frozen_string_literal: true

require 'faker'

module Uffizzi
  module ProjectHelper
    SLUG_ENDING_LENGTH = 6
    class << self
      def generate_default_params
        name = generate_name
        {
          name: name,
          description: default_description,
          slug: generate_slug(name),
        }
      end

      def generate_slug(name)
        formatted_name = name.downcase.gsub(/ /, '-').gsub(/[^\w-]+/, '')
        slug_ending = generate_random_string(SLUG_ENDING_LENGTH)

        "#{formatted_name}-#{slug_ending}"
      end

      private

      def generate_random_string(length)
        hexatridecimal_base = 36
        rand(hexatridecimal_base**length).to_s(hexatridecimal_base)
      end

      def default_description
        'Project generated by Uffizzi'
      end

      def generate_name
        Faker::Lorem.word
      end
    end
  end
end
