class Lbdb < Formula
  desc "Little brother's database for the mutt mail reader"
  homepage "https://www.spinnaker.de/lbdb/"
  url "https://www.spinnaker.de/lbdb/download/lbdb-0.56.tar.gz"
  sha256 "baa6a23b61394d792b7b221e1961d9ba5710614c9324e8f59b35c126c2b4e74e"
  license "GPL-2.0-or-later"

  livecheck do
    url "https://www.spinnaker.de/lbdb/download/"
    regex(/href=.*?lbdb[._-]v?(\d+(?:\.\d+)+)\.t/i)
  end

  depends_on "abook"
  depends_on "khard"

  def install
    system "./configure", "--libexecdir=#{lib}/lbdb", *std_configure_args
    system "make", "install"
  end

  test do
    assert_match version.major_minor.to_s, shell_output("#{bin}/lbdbq -v")
    assert_path_exists lib/"lbdb/m_abook", "m_abook module is missing!"
    assert_path_exists lib/"lbdb/m_khard", "m_khard module is missing!"
  end
end
