# Changelog

All notable changes to this project will be documented in this file.

## [0.2.0] - 2024-06-20

### 🐙 Features

- *(cheat)* Suport `cheat.sh` custom URL
- *(command)* Add timeout for terminating process ([#227](https://github.com/orhun/halp/issues/227))
- *(config)* Add defualt value for cheat.sh url
- *(help)* Improve the `cheat-sh-url` help
- *(help)* Improve the `cheat-sh-url` help
- *(helper)* Add more external help providers to plz menu
- *(log)* Show the path of the saved configuration file

### 🐛 Bug Fixes

- *(dialog)* Update usage according to the latest version of dialoguer

### 🚜 Refactor

- *(config)* Rename update_conf function to update_config
- *(config)* Refactor the config system ([#62](https://github.com/orhun/halp/issues/62))
- *(format)* Run cargo fmt
- *(lint)* Apply clippy suggestions
- *(lint)* Apply clippy suggestions
- *(test)* Fix the `fetch_cheat_sheet` test

### 📚 Documentation

- *(coc)* Fix typo
- *(license)* Update license copyright years
- *(license)* Update MIT license
- *(readme)* Update config format link
- *(readme)* Add usage example with coutom cheat.sh host URL
- *(readme)* Update `plz` subcommand usage
- *(readme)* Update `plz` subcommand usage

### ⚙️ Miscellaneous Tasks

- *(bors)* Remove bors config
- *(cargo)* Bump MSRV to 1.74.1
- *(cargo)* Add keywords for the crates.io release
- *(cargo)* Bump MSRV to 1.70.0
- *(changelog)* Skip dependency updates in changelog
- *(ci)* Update macos runner
- *(ci)* Update message while checking for MSRV
- *(docker)* Update the cargo-chef image
- *(git)* Remove IDEA directory from .gitignore
- *(mergify)* Add mergify config for automatic merges

### Clean

- *(docker)* Remove the duplicated `.gitignore` entry

## [0.1.7] - 2023-06-17

### 🚜 Refactor

- *(cli)* Use formatted usage text

### 🎨 Styling

- *(cli)* Override the help usage ([#30](https://github.com/orhun/halp/issues/30))

## [0.1.6] - 2023-04-18

### 🐙 Features

- *(docker)* Generate SBOM/provenance for the Docker image
- *(output)* Add separators for command output ([#27](https://github.com/orhun/halp/issues/27))

### 🎨 Styling

- *(output)* Add color to the separator
- *(readme)* Update license text

### ⚙️ Miscellaneous Tasks

- *(ci)* Switch back to line coverage
- *(ci)* Use codecov format with cargo-llvm-cov

## [0.1.5] - 2023-04-03

### ⚙️ Miscellaneous Tasks

- *(changelog)* Update git-cliff template about breaking changes

## [0.1.4] - 2023-03-17

### 🐛 Bug Fixes

- *(cheat)* Don't use a pager when no cheat sheet found for the command

### ⚙️ Miscellaneous Tasks

- *(ci)* Specify token for codecov uploads

## [0.1.3] - 2023-03-16

### 🐛 Bug Fixes

- *(args)* Unset pager for command output ([#9](https://github.com/orhun/halp/issues/9))

## [0.1.2] - 2023-03-14

### 🐙 Features

- *(args)* Check `version` subcommand for version info

### 📚 Documentation

- *(readme)* Update installation instructions for Arch Linux

### ⚙️ Miscellaneous Tasks

- *(changelog)* Skip PR related commits for changelog
- *(github)* Remove codeowner approval requirement from bors
- *(github)* Remove approval requirement from bors config
- *(github)* Remove docker status check from bors config

## [0.1.1] - 2023-03-13

### 📚 Documentation

- *(readme)* Match up common "help" and "version" arguments ([#3](https://github.com/orhun/halp/issues/3))

## [0.1.0] - 2023-03-12

### 📚 Documentation

- *(lib)* Add emoji to docs.rs description

## [0.1.0-rc.2] - 2023-03-12

### 🐛 Bug Fixes

- *(cd)* Update the packaging step for license files

<!-- generated by git-cliff -->
