class A52dec < Formula
  desc "Library for decoding ATSC A/52 streams (AKA 'AC-3')"
  homepage "https://git.adelielinux.org/community/a52dec/"
  url "https://distfiles.adelielinux.org/source/a52dec/a52dec-0.8.0.tar.gz"
  sha256 "03c181ce9c3fe0d2f5130de18dab9bd8bc63c354071515aa56983c74a9cffcc9"
  license "GPL-2.0-or-later"

  livecheck do
    url "https://pkg.adelielinux.org/current/a52dec"
    regex(/version\sv?(\d+(?:\.\d+)+)/i)
  end

  def install
    if OS.linux?
      # Fix error ld: imdct.lo: relocation R_X86_64_32 against `.bss' can not be
      # used when making a shared object; recompile with -fPIC
      ENV.append_to_cflags "-fPIC"
    else
      # Fixes duplicate symbols errors on arm64
      ENV.append_to_cflags "-std=gnu89"
    end

    system "./configure", *std_configure_args,
                          "--enable-shared",
                          "--mandir=#{man}"
    system "make", "install"
  end

  test do
    touch testpath/"test"
    system "#{bin}/a52dec", "-o", "null", "test"
  end
end
