/*
ͻ
 What's it called: EPMTeX-Keys v3.1   (texdefs.e)                           
                                                                            
 What does it do:  Defines the TeX overlay keys                             
                   (linked in automatically by texkeys.e)                   
                                                                            
 Who and When:     Jo Koenen 7/94                                           
                   Jon Hacker 8/95                                          
                                                                            
ͼ
*/
compile if TEXQUICKKEYS = 'yes'

    def S_F11 =
          universal tex_file_types

          isatexfiletype = pos(leftstr(filetype(),3),tex_file_types)
          if isatexfiletype then
              if (filetype() = 'LOG') then
                  sayerror 'Can''t TeX a LOG file.'
              else
                  'tex'
              endif
          else
              sayerror 'This filetype not defined as a TeX file type.'
          endif

    def S_F12 =
          universal tex_file_types

          isatexfiletype = pos(leftstr(filetype(),3),tex_file_types)
          if isatexfiletype then
              'tex_locate_error'
          else
              sayerror 'This filetype not defined as a TeX file type.'
          endif

compile endif -- TEXQUICKKEYS


/*
ͻ
 TeX syntax assist key definitions.                                         
                                                                            
 What does it do:  The enter and space bar keys have been defined to have   
                   specific TeX editing features in this keyset.            
                                                                            
ͼ
*/

compile if TEXSYNTAXASSIST = 'YES'

/*
Ŀ
  Define the action for the spacebar                                        
    The spacebar initiates the expansion of keywords                        

*/
  compile if EVERSION >= 5
    def space=
  compile else
    def ' '=
  compile endif

-- Note: expand_on is set dynamically by user to turn on syntax assist in EPM
  universal expand_on
  if expand_on then
    if not tex_first_expansion() then  -- search for keywords and expand 
      keyin ' '  -- default to a space if unable to expand word
    endif
  else
    keyin ' '  -- default is just a space with syntax assist disabled
  endif

  compile if EVERSION >= '5.20'
    undoaction 1, junk                -- Create a new state
  compile endif

/*
Ŀ
  Define the action for the enter (or ctrl-enter) key                       
    The enter key terminates the expansion of a keyword started with        
    the spacebar.                                                           

*/
-- global ASSIST_TRIGGER defines the key that starts syntax assist
  compile if not defined (ASSIST_TRIGGER)
    const ASSIST_TRIGGER = 'ENTER'  -- enter key is the default trigger
  compile endif

  compile if ASSIST_TRIGGER = 'ENTER'
    def enter=
    compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
      universal enterkey
    compile endif
  compile else
    def c_enter=
    compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''
      universal c_enterkey
    compile endif
  compile endif

  universal expand_on
  compile if EVERSION >= 5
    if expand_on then
  compile else
    if expand_on & not command_state() then
  compile endif -- EVERSION >= 5
    compile if EVERSION <= '4.12'
      if tex_second_expansion() then
        call maybe_autosave()
      else
    compile else
      if not tex_second_expansion() then  -- call the expansion procedure
    compile endif  -- EVERSION <= 4.12       and if no expansion possible then...
    compile if ASSIST_TRIGGER = 'ENTER'
      compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
        call enter_common(enterkey)
      compile else
        call my_enter()
      compile endif
    compile else  -- ASSIST_TRIGGER
      compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''
        call enter_common(c_enterkey)
      compile else
        call my_c_enter()
      compile endif
    compile endif -- ASSIST_TRIGGER
      endif  -- not tex_second_expansion
 
    else  -- expand_on is off so enter does default actions only
    compile if ASSIST_TRIGGER = 'ENTER'
      compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
        call enter_common(enterkey)
      compile else
        call my_enter()
      compile endif
    compile else  -- ASSIST_TRIGGER
      compile if ENHANCED_ENTER_KEYS & c_ENTER_ACTION <> ''
        call enter_common(c_enterkey)
      compile else
        call my_c_enter()
      compile endif
    compile endif -- ASSIST_TRIGGER
    endif  -- expand_on

compile endif -- TEXSYNTAXASSIST

/*
ͻ
 TeX syntax accelerator key definitions.                                    
                                                                            
 What does it do:  Defines keys for TeX syntax accelerators                 
                                                                            
ͼ
*/

compile if TEXACCELKEYS = 'YES'

    def c_x=       /* Force expansion if we don't have it turned on automatic */
        if not tex_first_expansion() then
          call tex_second_expansion()
        endif

    def a_a=
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'eqnarray'line_r
        .col=.col+8

    def a_b =
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\begin{}'line_r
        .col=.col+7

    def a_c =
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\cite{}'line_r
        .col=.col+6

    def a_d=
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'description'line_r
        .col=.col+11

    def a_e = 
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'equation'line_r
        .col=.col+8

    def a_f =
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\frac{}{}'line_r
        .col=.col+6

    def a_h = 
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\hspace*{}'line_r
        .col=.col+9

    def a_i =
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\item'line_r
        .col=.col+5

    def a_j = 
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'itemize'line_r
        .col=.col+7

    def a_k = 
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'tabular'line_r
        .col=.col+7

    def a_l =
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\label{}'line_r
        .col=.col+7

    def a_m =
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\mbox{}'line_r
        .col=.col+6

    def a_n = 
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'enumerate'line_r
        .col=.col+9

    def a_q =
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'equation'line_r
        .col=.col+8

    def a_r=
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\ref{}'line_r
       .col=.col+5

    def a_s = 
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\sqrt{}'line_r
        .col=.col+6

    def a_v=
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'\vspace*{}'line_r
        .col=.col+9
 
    def a_w = 
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'verbatim'line_r
        .col=.col+8
 
    def '{'=
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'{}'line_r
        .col=.col+1

    def '$'=
        getline line
        line_l=substr(line,1,.col-1)
        line_r=substr(line,.col)
        replaceline line_l'$$'line_r
        .col=.col+1

compile endif -- TEXACCELKEYS

