#include <stdio.h>


long gcd(long x, long y)
{
  while (x && y) 
    if (x > y)
      x %= y;
    else
      y %= x;
  return x == 0 ? y : x;
}

void swap(int *i1, int *i2)
{
  int t = *i1;
  *i1 = *i2;
  *i2 = t;
}

void tbl(int m)
{
  int i, n, d, div, p1, p2, l;
  int num[100], den[100];

  l = 0;

  for (n = 0; n <= m; ++n) 

    for (d = n; d <= m; ++d) {

      if (d == 0)
        continue;

      div = gcd(n, d);

      num[l] = n/div;
      den[l] = d/div;

      i = l++;
      while ((p1 = num[i] * den[i-1]) < (p2 = den[i] * num[i-1])) {
        swap(&num[i], &num[i-1]);
        swap(&den[i], &den[i-1]);
        --i;
      }
      if (p1 == p2) {
        --l;
        while (i < l) {
          num[i] = num[i+1];
          den[i] = den[i+1];
          ++i;
        }
      }
    }

  /* Sentinel. */
  num[l] = 2;
  den[l] = 1;
  for (i = 0; i < l; ++i) {
    printf("%3d,%2d, ", num[i], den[i]);
    if (i == 0) 
      printf(" 0, 1,\n");
    else {
      n = num[i-1]*den[i] + num[i]*den[i-1];
      d = 2 * den[i-1] * den[i];
      div = gcd(n, d);
      printf("%2d,%2d,\n", n/div, d/div);
    }
  }
  printf("  1, 1,  2, 1\n");
}

void main(void)
{
  printf("/* Line and vector slope tables. */\n\n");
  printf("struct slope {\n"
         "  signed char num, den;\n"
         "  signed char snum, sden;\n"
         "};\n\n");
  printf("struct slope line_slopes[] = {\n"); tbl(6); printf("};\n\n");
  printf("struct slope vect_slopes[] = {\n"); tbl(4); printf("};\n\n");
  printf("#define N_LINE_SLOPES (sizeof line_slopes/sizeof line_slopes[0])\n"
         "#define N_VECT_SLOPES (sizeof vect_slopes/sizeof vect_slopes[0])\n");
}
