/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* DATETIME.C --- Convert date and time to string
   in a nice format. Like ctime(), but without
   seconds, day of week, and terminating newline. */
#include <stdio.h>
#include <time.h>

/* Return date/time in a sane format. */
char *dtg(void)
{
  static char buf[20];
  static char mstr[][4] = { 
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" 
  };
  time_t t;
  struct tm *tm;

  time(&t);
  tm = localtime(&t);
  sprintf(buf, "%d %s %02d, %d:%02d", 
	  tm->tm_mday, 
	  mstr[tm->tm_mon],
	  tm->tm_year,
	  tm->tm_hour,
	  tm->tm_min);
  return buf;
}
