/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.info;

import io.smallrye.openapi.api.models.info.LicenseImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.info.License;
import org.jboss.jandex.AnnotationInstance;

public class LicenseIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<License, V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";
    private static final String PROP_URL = "url";
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public LicenseIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.LICENSE, Names.create(License.class));
        this.extensionIO = extensionIO;
    }

    @Override
    public License read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@License");
        LicenseImpl license = new LicenseImpl();
        license.setName((String)this.value(annotation, PROP_NAME));
        license.setUrl((String)this.value(annotation, PROP_URL));
        license.setExtensions(this.extensionIO.readExtensible(annotation));
        return license;
    }

    @Override
    public License readObject(O node) {
        IoLogging.logger.singleJsonNode("License");
        LicenseImpl license = new LicenseImpl();
        license.setName(this.jsonIO().getString(node, PROP_NAME));
        license.setUrl(this.jsonIO().getString(node, PROP_URL));
        license.setExtensions(this.extensionIO.readMap(node));
        return license;
    }

    @Override
    public Optional<O> write(License model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_NAME, this.jsonIO().toJson(model.getName()));
            this.setIfPresent(node, PROP_URL, this.jsonIO().toJson(model.getUrl()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

