/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureFormat;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.PropertyView;
import org.apache.sis.feature.Validator;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CheckedArrayList;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;

public abstract class AbstractFeature
implements Serializable {
    private static final long serialVersionUID = -5637918246427380190L;
    static final Object MISSING = new Object();
    final DefaultFeatureType type;
    private static final ThreadLocal<IdentityHashMap<AbstractFeature, Boolean>> COMPARING = ThreadLocal.withInitial(IdentityHashMap::new);

    protected AbstractFeature(DefaultFeatureType type) {
        ArgumentChecks.ensureNonNull("type", type);
        this.type = type;
    }

    final String getName() {
        return String.valueOf(this.type.getName());
    }

    public DefaultFeatureType getType() {
        return this.type;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return PropertyView.create(this, this.type.getProperty(name));
    }

    public void setProperty(Object property) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("property", property);
        String name = ((Property)property).getName().toString();
        this.verifyPropertyType(name, (Property)property);
        if (property instanceof AbstractAttribute && !Containers.isNullOrEmpty(((AbstractAttribute)property).characteristics())) {
            throw new IllegalArgumentException(Resources.format((short)2, name));
        }
        this.setPropertyValue(name, ((Property)property).getValue());
    }

    final Property createProperty(String name, Object value) {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            return AbstractAttribute.create((DefaultAttributeType)pt, value);
        }
        if (pt instanceof DefaultAssociationRole) {
            return AbstractAssociation.create((DefaultAssociationRole)pt, value);
        }
        throw new CorruptedObjectException(Errors.format((short)149, pt));
    }

    final Property createProperty(String name) throws IllegalArgumentException {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            return ((DefaultAttributeType)pt).newInstance();
        }
        if (pt instanceof DefaultAssociationRole) {
            return ((DefaultAssociationRole)pt).newInstance();
        }
        throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(pt.getName()));
    }

    final Object getOperationResult(String name) {
        assert (DefaultFeatureType.OPERATION_INDEX.equals(this.type.indices().get(name))) : name;
        return ((AbstractOperation)this.type.getProperty(name)).apply(this, null);
    }

    final Object getDefaultValue(String name) throws IllegalArgumentException {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            return AbstractFeature.getDefaultValue((DefaultAttributeType)pt);
        }
        if (pt instanceof DefaultAssociationRole) {
            int maximumOccurs = ((DefaultAssociationRole)pt).getMaximumOccurs();
            return maximumOccurs > 1 ? Collections.EMPTY_LIST : null;
        }
        throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(pt.getName()));
    }

    private static <V> Object getDefaultValue(DefaultAttributeType<V> attribute) {
        V defaultValue = attribute.getDefaultValue();
        if (Field.isSingleton(attribute.getMaximumOccurs())) {
            return defaultValue;
        }
        return defaultValue != null ? Collections.singletonList(defaultValue) : Collections.emptyList();
    }

    public abstract Object getPropertyValue(String var1) throws IllegalArgumentException;

    public abstract void setPropertyValue(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getValueOrFallback(String var1, Object var2);

    protected Object getOperationValue(String name) {
        AbstractOperation operation = (AbstractOperation)this.type.getProperty(name);
        if (operation instanceof LinkOperation) {
            return this.getPropertyValue(((LinkOperation)operation).referentName);
        }
        Object result = operation.apply(this, null);
        if (result instanceof AbstractAttribute) {
            return AbstractFeature.getAttributeValue((AbstractAttribute)result);
        }
        if (result instanceof AbstractAssociation) {
            return AbstractFeature.getAssociationValue((AbstractAssociation)result);
        }
        return null;
    }

    protected void setOperationValue(String name, Object value) {
        AbstractOperation operation = (AbstractOperation)this.type.getProperty(name);
        if (operation instanceof LinkOperation) {
            this.setPropertyValue(((LinkOperation)operation).referentName, value);
        } else {
            Object result = operation.apply(this, null);
            if (result instanceof Property) {
                AbstractFeature.setPropertyValue((Property)result, value);
            } else {
                throw new IllegalStateException(Resources.format((short)12, name));
            }
        }
    }

    static Object getAttributeValue(AbstractAttribute<?> property) {
        return Field.isSingleton(property.getType().getMaximumOccurs()) ? property.getValue() : property.getValues();
    }

    static Object getAssociationValue(AbstractAssociation property) {
        return Field.isSingleton(property.getRole().getMaximumOccurs()) ? property.getValue() : property.getValues();
    }

    static void setPropertyValue(Property property, Object value) {
        if (property instanceof AbstractAttribute) {
            AbstractFeature.setAttributeValue((AbstractAttribute)property, value);
        } else if (property instanceof AbstractAssociation) {
            AbstractFeature.setAssociationValue((AbstractAssociation)property, value);
        } else {
            throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(property.getName()));
        }
    }

    private static <V> void setAttributeValue(AbstractAttribute<V> attribute, Object value) {
        DefaultAttributeType<V> pt;
        Class<V> base;
        if (value != null && !(base = (pt = attribute.getType()).getValueClass()).isInstance(value)) {
            Object element = value;
            if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                do {
                    if (it.hasNext()) continue;
                    attribute.setValues((Collection)value);
                    return;
                } while ((element = it.next()) == null || base.isInstance(element));
            }
            throw new ClassCastException(AbstractFeature.illegalValueClass(pt, base, element));
        }
        attribute.setValue(value);
    }

    private static void setAssociationValue(AbstractAssociation association, Object value) {
        if (value != null) {
            DefaultAssociationRole role = association.getRole();
            DefaultFeatureType base = role.getValueType();
            if (value instanceof AbstractFeature) {
                DefaultFeatureType actual = ((AbstractFeature)value).getType();
                if (base != actual && !DefaultFeatureType.maybeAssignableFrom(base, actual)) {
                    throw new IllegalArgumentException(AbstractFeature.illegalFeatureType(role, base, actual));
                }
            } else {
                if (value instanceof Collection) {
                    AbstractFeature.verifyAssociationValues(role, (Collection)value);
                    association.setValues((Collection)value);
                    return;
                }
                throw new ClassCastException(AbstractFeature.illegalValueClass(role, AbstractFeature.class, value));
            }
        }
        association.setValue((AbstractFeature)value);
    }

    static boolean canSkipVerification(Object previous, Object value) {
        if (previous != null) {
            if (value == null) {
                return true;
            }
            if (previous.getClass() == value.getClass() && !(value instanceof AbstractFeature)) {
                return true;
            }
        }
        return false;
    }

    final void verifyPropertyType(String name, Property property) {
        FieldType pt;
        AbstractIdentifiedType base = this.type.getProperty(name);
        if (property instanceof AbstractAttribute) {
            pt = ((AbstractAttribute)property).getType();
        } else if (property instanceof AbstractAssociation) {
            pt = ((AbstractAssociation)property).getRole();
        } else {
            throw new IllegalArgumentException(Resources.format((short)29, base.getName(), property.getClass()));
        }
        if (pt != base) {
            if (base == null) {
                throw new IllegalArgumentException(Resources.format((short)59, this.getName(), name));
            }
            throw new IllegalArgumentException(Resources.format((short)45, name));
        }
    }

    final Object verifyPropertyValue(String name, Object value) {
        AbstractIdentifiedType pt = this.type.getProperty(name);
        if (pt instanceof DefaultAttributeType) {
            if (value != null) {
                return AbstractFeature.verifyAttributeValue((DefaultAttributeType)pt, value);
            }
        } else if (pt instanceof DefaultAssociationRole) {
            if (value != null) {
                return AbstractFeature.verifyAssociationValue((DefaultAssociationRole)pt, value);
            }
        } else {
            throw new IllegalArgumentException(AbstractFeature.unsupportedPropertyType(pt.getName()));
        }
        return value;
    }

    private static <T> Object verifyAttributeValue(DefaultAttributeType<T> type, Object value) {
        Class<T> valueClass = type.getValueClass();
        boolean isSingleton = Field.isSingleton(type.getMaximumOccurs());
        if (valueClass.isInstance(value)) {
            return isSingleton ? value : AbstractFeature.singletonList(valueClass, type.getMinimumOccurs(), value);
        }
        if (!isSingleton && value instanceof Collection) {
            return CheckedArrayList.castOrCopy(value, valueClass);
        }
        throw new ClassCastException(AbstractFeature.illegalValueClass(type, valueClass, value));
    }

    private static Object verifyAssociationValue(DefaultAssociationRole role, Object value) {
        boolean isSingleton = Field.isSingleton(role.getMaximumOccurs());
        if (value instanceof AbstractFeature) {
            DefaultFeatureType valueType = ((AbstractFeature)((Object)value)).getType();
            DefaultFeatureType base = role.getValueType();
            if (base == valueType || DefaultFeatureType.maybeAssignableFrom(base, valueType)) {
                return isSingleton ? value : AbstractFeature.singletonList(AbstractFeature.class, role.getMinimumOccurs(), value);
            }
            throw new IllegalArgumentException(AbstractFeature.illegalFeatureType(role, base, valueType));
        }
        if (!isSingleton && value instanceof Collection) {
            AbstractFeature.verifyAssociationValues(role, value);
            return CheckedArrayList.castOrCopy(value, AbstractFeature.class);
        }
        throw new ClassCastException(AbstractFeature.illegalValueClass(role, AbstractFeature.class, value));
    }

    private static void verifyAssociationValues(DefaultAssociationRole role, Collection<?> values) {
        DefaultFeatureType base = role.getValueType();
        int index = 0;
        for (Object value : values) {
            ArgumentChecks.ensureNonNullElement("values", index, value);
            if (!(value instanceof AbstractFeature)) {
                throw new ClassCastException(AbstractFeature.illegalValueClass(role, AbstractFeature.class, value));
            }
            DefaultFeatureType type = ((AbstractFeature)value).getType();
            if (base != type && !DefaultFeatureType.maybeAssignableFrom(base, type)) {
                throw new IllegalArgumentException(AbstractFeature.illegalFeatureType(role, base, type));
            }
            ++index;
        }
    }

    private static <V> Collection<V> singletonList(Class<V> valueClass, int minimumOccurs, Object value) {
        CheckedArrayList<V> values = new CheckedArrayList<V>(valueClass, Math.max(minimumOccurs, 4));
        values.add(value);
        return values;
    }

    static String propertyNotFound(FeatureType type, Object feature, String property) {
        GenericName ambiguous = null;
        for (AbstractIdentifiedType p : type.getProperties(true)) {
            GenericName next;
            GenericName name = next = p.getName();
            do {
                if (!property.equalsIgnoreCase(name.toString())) continue;
                if (ambiguous == null) {
                    ambiguous = next;
                    continue;
                }
                return Errors.format((short)1, ambiguous, next, property);
            } while (name instanceof ScopedName && (name = ((ScopedName)name).tail()) != null);
        }
        return Resources.format((short)59, feature, property);
    }

    static String unsupportedPropertyType(GenericName name) {
        return Resources.format((short)7, name);
    }

    private static String illegalValueClass(AbstractIdentifiedType property, Class<?> expected, Object value) {
        return Resources.format((short)30, property.getName(), expected, value.getClass());
    }

    private static String illegalFeatureType(DefaultAssociationRole association, FeatureType expected, FeatureType actual) {
        return Resources.format((short)26, association.getName(), expected.getName(), actual.getName());
    }

    public DataQuality quality() {
        Validator v = new Validator(ScopeCode.FEATURE);
        v.validate(this.type, this);
        return v.quality;
    }

    public String toString() {
        return FeatureFormat.sharedFormat(this);
    }

    final boolean comparisonStart() {
        return COMPARING.get().put(this, Boolean.TRUE) == null;
    }

    final void comparisonEnd() {
        if (!Boolean.TRUE.equals(COMPARING.get().remove(this))) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int code = this.type.hashCode() * 37;
        if (this.comparisonStart()) {
            try {
                for (AbstractIdentifiedType pt : this.type.getProperties(true)) {
                    Object value;
                    String name = pt.getName().toString();
                    if (name == null || (value = this.getPropertyValue(name)) == null) continue;
                    code += name.hashCode() ^ value.hashCode();
                }
            }
            finally {
                this.comparisonEnd();
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj != this) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            AbstractFeature that = (AbstractFeature)obj;
            if (!this.type.equals(that.type)) {
                return false;
            }
            if (this.comparisonStart()) {
                try {
                    for (AbstractIdentifiedType pt : this.type.getProperties(true)) {
                        String name = pt.getName().toString();
                        if (Objects.equals(this.getPropertyValue(name), that.getPropertyValue(name))) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    this.comparisonEnd();
                }
            }
        }
        return true;
    }
}

