/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.model.ConstructorParameter;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class ModelClassConstructor<M> {
    private final Constructor<M> constructor;
    private final boolean hasInjectAnnotation;
    private final ConstructorParameter[] constructorParametersArray;

    public ModelClassConstructor(Constructor<M> constructor, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        this.constructor = constructor;
        this.hasInjectAnnotation = constructor.isAnnotationPresent(Inject.class);
        Parameter[] parameters = constructor.getParameters();
        this.constructorParametersArray = (ConstructorParameter[])IntStream.range(0, parameters.length).mapToObj(i -> ConstructorParameter.of(parameters[i], i, processorFactories, defaultInjectionStrategy)).toArray(ConstructorParameter[]::new);
    }

    public M newInstance(Object ... parameters) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.constructor.setAccessible(true);
        return this.constructor.newInstance(parameters);
    }

    public Constructor<M> getConstructor() {
        return this.constructor;
    }

    public boolean hasInjectAnnotation() {
        return this.hasInjectAnnotation;
    }

    public ConstructorParameter[] getConstructorParameters() {
        return this.constructorParametersArray;
    }

    public boolean isCanonicalRecordConstructor() {
        Class<M> declaringClass = this.constructor.getDeclaringClass();
        boolean areBalancedCtorParamsAndFields = ReflectionUtil.areBalancedCtorParamsAndFields(this.constructor);
        boolean isRecordDeclaringClass = ReflectionUtil.isRecord(declaringClass);
        return areBalancedCtorParamsAndFields && isRecordDeclaringClass;
    }
}

