/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.loader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.AgentPackagePath;
import org.apache.skywalking.apm.agent.core.boot.PluginConfig;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.SnifferConfigInitializer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.PluginBootstrap;

public class AgentClassLoader
extends ClassLoader {
    private static final ILog LOGGER;
    private static AgentClassLoader DEFAULT_LOADER;
    private List<File> classpath;
    private List<Jar> allJars;
    private ReentrantLock jarScanLock = new ReentrantLock();

    public static AgentClassLoader getDefault() {
        return DEFAULT_LOADER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initDefaultLoader() throws AgentPackageNotFoundException {
        if (DEFAULT_LOADER != null) return;
        Class<AgentClassLoader> clazz = AgentClassLoader.class;
        synchronized (AgentClassLoader.class) {
            if (DEFAULT_LOADER != null) return;
            DEFAULT_LOADER = new AgentClassLoader(PluginBootstrap.class.getClassLoader());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public AgentClassLoader(ClassLoader parent) throws AgentPackageNotFoundException {
        super(parent);
        File agentDictionary = AgentPackagePath.getPath();
        this.classpath = new LinkedList<File>();
        Config.Plugin.MOUNT.forEach(mountFolder -> this.classpath.add(new File(agentDictionary, (String)mountFolder)));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        List<Jar> allJars = this.getAllJars();
        String path = name.replace('.', '/').concat(".class");
        for (Jar jar : allJars) {
            JarEntry entry = jar.jarFile.getJarEntry(path);
            if (entry == null) continue;
            try {
                byte[] data;
                URL classFileUrl = new URL("jar:file:" + jar.sourceFile.getAbsolutePath() + "!/" + path);
                try (BufferedInputStream is = new BufferedInputStream(classFileUrl.openStream());
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int ch;
                    while ((ch = is.read()) != -1) {
                        baos.write(ch);
                    }
                    data = baos.toByteArray();
                }
                return this.processLoadedClass(this.defineClass(name, data, 0, data.length));
            }
            catch (IOException e) {
                LOGGER.error(e, "find class fail.", new Object[0]);
            }
        }
        throw new ClassNotFoundException("Can't find " + name);
    }

    @Override
    protected URL findResource(String name) {
        List<Jar> allJars = this.getAllJars();
        for (Jar jar : allJars) {
            JarEntry entry = jar.jarFile.getJarEntry(name);
            if (entry == null) continue;
            try {
                return new URL("jar:file:" + jar.sourceFile.getAbsolutePath() + "!/" + name);
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        LinkedList<URL> allResources = new LinkedList<URL>();
        List<Jar> allJars = this.getAllJars();
        for (Jar jar : allJars) {
            JarEntry entry = jar.jarFile.getJarEntry(name);
            if (entry == null) continue;
            allResources.add(new URL("jar:file:" + jar.sourceFile.getAbsolutePath() + "!/" + name));
        }
        final Iterator iterator = allResources.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)iterator.next();
            }
        };
    }

    private Class<?> processLoadedClass(Class<?> loadedClass) {
        PluginConfig pluginConfig = loadedClass.getAnnotation(PluginConfig.class);
        if (pluginConfig != null) {
            SnifferConfigInitializer.initializeConfig(pluginConfig.root());
        }
        return loadedClass;
    }

    private List<Jar> getAllJars() {
        if (this.allJars == null) {
            this.jarScanLock.lock();
            try {
                if (this.allJars == null) {
                    this.allJars = this.doGetJars();
                }
            }
            finally {
                this.jarScanLock.unlock();
            }
        }
        return this.allJars;
    }

    private LinkedList<Jar> doGetJars() {
        LinkedList<Jar> jars = new LinkedList<Jar>();
        for (File path : this.classpath) {
            String[] jarFileNames;
            if (!path.exists() || !path.isDirectory()) continue;
            for (String fileName : jarFileNames = path.list((dir, name) -> name.endsWith(".jar"))) {
                try {
                    File file = new File(path, fileName);
                    Jar jar = new Jar(new JarFile(file), file);
                    jars.add(jar);
                    LOGGER.info("{} loaded.", file.toString());
                }
                catch (IOException e) {
                    LOGGER.error(e, "{} jar file can't be resolved", fileName);
                }
            }
        }
        return jars;
    }

    static {
        AgentClassLoader.registerAsParallelCapable();
        LOGGER = LogManager.getLogger(AgentClassLoader.class);
    }

    private static class Jar {
        private final JarFile jarFile;
        private final File sourceFile;

        @Generated
        public Jar(JarFile jarFile, File sourceFile) {
            this.jarFile = jarFile;
            this.sourceFile = sourceFile;
        }
    }
}

