/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.trace;

import lombok.Generated;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.network.language.agent.v3.RefType;
import org.apache.skywalking.apm.network.language.agent.v3.SegmentReference;

public class TraceSegmentRef {
    private SegmentRefType type;
    private String traceId;
    private String traceSegmentId;
    private int spanId;
    private String parentService;
    private String parentServiceInstance;
    private String parentEndpoint;
    private String addressUsedAtClient;

    public TraceSegmentRef(ContextCarrier carrier) {
        this.type = SegmentRefType.CROSS_PROCESS;
        this.traceId = carrier.getTraceId();
        this.traceSegmentId = carrier.getTraceSegmentId();
        this.spanId = carrier.getSpanId();
        this.parentService = carrier.getParentService();
        this.parentServiceInstance = carrier.getParentServiceInstance();
        this.parentEndpoint = carrier.getParentEndpoint();
        this.addressUsedAtClient = carrier.getAddressUsedAtClient();
    }

    public TraceSegmentRef(ContextSnapshot snapshot) {
        this.type = SegmentRefType.CROSS_THREAD;
        this.traceId = snapshot.getTraceId().getId();
        this.traceSegmentId = snapshot.getTraceSegmentId();
        this.spanId = snapshot.getSpanId();
        this.parentService = Config.Agent.SERVICE_NAME;
        this.parentServiceInstance = Config.Agent.INSTANCE_NAME;
        this.parentEndpoint = snapshot.getParentEndpoint();
    }

    public SegmentReference transform() {
        SegmentReference.Builder refBuilder = SegmentReference.newBuilder();
        if (SegmentRefType.CROSS_PROCESS.equals((Object)this.type)) {
            refBuilder.setRefType(RefType.CrossProcess);
        } else {
            refBuilder.setRefType(RefType.CrossThread);
        }
        refBuilder.setTraceId(this.traceId);
        refBuilder.setParentTraceSegmentId(this.traceSegmentId);
        refBuilder.setParentSpanId(this.spanId);
        refBuilder.setParentService(this.parentService);
        refBuilder.setParentServiceInstance(this.parentServiceInstance);
        refBuilder.setParentEndpoint(this.parentEndpoint);
        if (this.addressUsedAtClient != null) {
            refBuilder.setNetworkAddressUsedAtPeer(this.addressUsedAtClient);
        }
        return refBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceSegmentRef ref = (TraceSegmentRef)o;
        if (this.spanId != ref.spanId) {
            return false;
        }
        return this.traceSegmentId.equals(ref.traceSegmentId);
    }

    public int hashCode() {
        int result = this.traceSegmentId.hashCode();
        result = 31 * result + this.spanId;
        return result;
    }

    @Generated
    public SegmentRefType getType() {
        return this.type;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public int getSpanId() {
        return this.spanId;
    }

    @Generated
    public String getParentService() {
        return this.parentService;
    }

    @Generated
    public String getParentServiceInstance() {
        return this.parentServiceInstance;
    }

    @Generated
    public String getParentEndpoint() {
        return this.parentEndpoint;
    }

    @Generated
    public String getAddressUsedAtClient() {
        return this.addressUsedAtClient;
    }

    public static enum SegmentRefType {
        CROSS_PROCESS,
        CROSS_THREAD;

    }
}

