/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.sentinel.v1;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;

public class EntryMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        Object span = ContextManager.getRuntimeContext().get((Object)"SW_SENTINEL_SPAN");
        if (span != null) {
            if (t instanceof BlockException) {
                HashMap<String, String> eventMap = new HashMap<String, String>();
                eventMap.put("blocked", "true");
                if (t instanceof FlowException) {
                    eventMap.put("block_type", "flow");
                } else if (t instanceof DegradeException) {
                    eventMap.put("block_type", "degrade");
                } else if (t instanceof SystemBlockException) {
                    eventMap.put("block_type", "system");
                } else if (t instanceof AuthorityException) {
                    eventMap.put("block_type", "authority");
                }
                ((AbstractSpan)span).log(System.currentTimeMillis(), eventMap);
            } else {
                ((AbstractSpan)span).log(t);
            }
            ContextManager.getRuntimeContext().remove((Object)"SW_SENTINEL_SPAN");
        }
    }
}

