/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.apm.plugin.hystrix.v1;

import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;

/**
 * {@link EnhanceRequireObjectCache} record the prefix operation name of span and {@link ContextSnapshot} object for
 * tracing.
 */
public class EnhanceRequireObjectCache {
    private final String operationNamePrefix;
    private ContextSnapshot contextSnapshot;

    public EnhanceRequireObjectCache(String prefix) {
        operationNamePrefix = prefix;
    }

    public String getOperationNamePrefix() {
        return operationNamePrefix;
    }

    public ContextSnapshot getContextSnapshot() {
        return contextSnapshot;
    }

    public void setContextSnapshot(ContextSnapshot contextSnapshot) {
        this.contextSnapshot = contextSnapshot;
    }
}
