/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Test patterns for different categories
export const testPatterns = {
  utils: "src/utils/**/*.spec.ts",
  components: "src/components/**/*.spec.ts",
  hooks: "src/hooks/**/*.spec.ts",
  stores: "src/store/**/*.spec.ts",
  views: "src/views/**/*.spec.ts",
  integration: "src/**/*.spec.ts",
};

// Test configuration for different categories
export const testConfigs = {
  utils: {
    pattern: testPatterns.utils,
    coverage: {
      provider: "v8",
      reporter: ["text", "json", "html"],
      exclude: ["node_modules/", "src/test/", "**/*.d.ts"],
    },
  },
  components: {
    pattern: testPatterns.components,
    coverage: {
      provider: "v8",
      reporter: ["text", "json", "html"],
      exclude: ["node_modules/", "src/test/", "**/*.d.ts"],
    },
  },
  hooks: {
    pattern: testPatterns.hooks,
    coverage: {
      provider: "v8",
      reporter: ["text", "json", "html"],
      exclude: ["node_modules/", "src/test/", "**/*.d.ts"],
    },
  },
  stores: {
    pattern: testPatterns.stores,
    coverage: {
      provider: "v8",
      reporter: ["text", "json", "html"],
      exclude: ["node_modules/", "src/test/", "**/*.d.ts"],
    },
  },
  all: {
    pattern: testPatterns.integration,
    coverage: {
      provider: "v8",
      reporter: ["text", "json", "html"],
      exclude: [
        "node_modules/",
        "src/test/",
        "**/*.d.ts",
        "**/*.config.*",
        "dist/",
        "cypress/",
        "src/types/",
        "src/mock/",
      ],
    },
  },
};
