/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.amqp;

import java.math.BigDecimal;
import java.nio.ByteBuffer;

public final class Decimal128
extends Number {
    private final BigDecimal _underlying;
    private final long _msb;
    private final long _lsb;

    public Decimal128(BigDecimal underlying) {
        this._underlying = underlying;
        this._msb = Decimal128.calculateMostSignificantBits(underlying);
        this._lsb = Decimal128.calculateLeastSignificantBits(underlying);
    }

    public Decimal128(long msb, long lsb) {
        this._msb = msb;
        this._lsb = lsb;
        this._underlying = Decimal128.calculateBigDecimal(msb, lsb);
    }

    public Decimal128(byte[] data) {
        this(ByteBuffer.wrap(data));
    }

    private Decimal128(ByteBuffer buffer) {
        this(buffer.getLong(), buffer.getLong());
    }

    private static long calculateMostSignificantBits(BigDecimal underlying) {
        return 0L;
    }

    private static long calculateLeastSignificantBits(BigDecimal underlying) {
        return 0L;
    }

    private static BigDecimal calculateBigDecimal(long msb, long lsb) {
        return BigDecimal.ZERO;
    }

    @Override
    public int intValue() {
        return this._underlying.intValue();
    }

    @Override
    public long longValue() {
        return this._underlying.longValue();
    }

    @Override
    public float floatValue() {
        return this._underlying.floatValue();
    }

    @Override
    public double doubleValue() {
        return this._underlying.doubleValue();
    }

    public long getMostSignificantBits() {
        return this._msb;
    }

    public long getLeastSignificantBits() {
        return this._lsb;
    }

    public byte[] asBytes() {
        byte[] bytes = new byte[16];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.putLong(this.getMostSignificantBits());
        buf.putLong(this.getLeastSignificantBits());
        return bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decimal128 that = (Decimal128)o;
        if (this._lsb != that._lsb) {
            return false;
        }
        return this._msb == that._msb;
    }

    public int hashCode() {
        int result = (int)(this._msb ^ this._msb >>> 32);
        result = 31 * result + (int)(this._lsb ^ this._lsb >>> 32);
        return result;
    }
}

