/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.schema;

import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.DataException;

public class ConnectEnum {
    public static final String LOGICAL_PARAMETER = "org.apache.kafka.connect.data.Enum";

    public static SchemaBuilder builder(String annotation, List<String> symbols) {
        SchemaBuilder builder = SchemaBuilder.string().parameter(LOGICAL_PARAMETER, annotation);
        for (int i = 0; i < symbols.size(); ++i) {
            builder.parameter("org.apache.kafka.connect.data.Enum." + symbols.get(i), String.valueOf(i));
        }
        return builder;
    }

    public static SchemaBuilder builder(String annotation, Map<String, Integer> symbols) {
        SchemaBuilder builder = SchemaBuilder.string().parameter(LOGICAL_PARAMETER, annotation);
        for (Map.Entry<String, Integer> symbol : symbols.entrySet()) {
            builder.parameter("org.apache.kafka.connect.data.Enum." + symbol.getKey(), String.valueOf(symbol.getValue()));
        }
        return builder;
    }

    public static boolean isEnum(Schema schema) {
        return schema != null && schema.parameters() != null && schema.parameters().containsKey(LOGICAL_PARAMETER);
    }

    public static boolean hasEnumSymbol(Schema schema, String symbol) {
        return schema != null && schema.parameters() != null && schema.parameters().containsKey(LOGICAL_PARAMETER) && schema.parameters().containsKey("org.apache.kafka.connect.data.Enum." + symbol);
    }

    public static <T extends Enum<T>> String fromLogical(Schema schema, T value) {
        if (!ConnectEnum.hasEnumSymbol(schema, value.name())) {
            throw new DataException("Requested conversion of Enum object but the schema does not match.");
        }
        return value.name();
    }

    public static <T extends Enum<T>> T toLogical(Schema schema, Class<T> cls, String symbol) {
        if (!ConnectEnum.hasEnumSymbol(schema, symbol)) {
            throw new DataException("Requested conversion of Enum object but the schema does not match.");
        }
        return Enum.valueOf(cls, symbol);
    }

    public static int toOrdinal(Schema schema, String symbol) {
        if (!ConnectEnum.hasEnumSymbol(schema, symbol)) {
            throw new DataException("Requested conversion of Enum object but the schema does not match.");
        }
        return Integer.parseInt((String)schema.parameters().get("org.apache.kafka.connect.data.Enum." + symbol));
    }
}

