/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect.schema;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.confluent.connect.avro.AvroData;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSchemaToKafkaSchema {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarSchemaToKafkaSchema.class);
    private static final ImmutableMap<SchemaType, org.apache.kafka.connect.data.Schema> pulsarSchemaTypeToKafkaSchema;
    private static final ImmutableMap<SchemaType, org.apache.kafka.connect.data.Schema> pulsarSchemaTypeToOptionalKafkaSchema;
    private static final ImmutableSet<String> kafkaLogicalSchemas;
    private static final AvroData avroData;
    private static final Cache<byte[], org.apache.kafka.connect.data.Schema> schemaCache;
    private static final Cache<org.apache.kafka.connect.data.Schema, org.apache.kafka.connect.data.Schema> optionalSchemaCache;

    public static boolean matchesToKafkaLogicalSchema(org.apache.kafka.connect.data.Schema kafkaSchema) {
        return kafkaLogicalSchemas.contains((Object)kafkaSchema.name());
    }

    private static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    public static org.apache.kafka.connect.data.Schema makeOptional(org.apache.kafka.connect.data.Schema s) {
        if (s == null || s.isOptional()) {
            return s;
        }
        String logicalSchemaName = s.name();
        if (kafkaLogicalSchemas.contains((Object)logicalSchemaName)) {
            return s;
        }
        try {
            return (org.apache.kafka.connect.data.Schema)optionalSchemaCache.get((Object)s, () -> new OptionalForcingSchema(s));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException ee) {
            String msg = "Failed to create optional schema for " + String.valueOf(s);
            log.error(msg);
            throw new IllegalStateException(msg, ee);
        }
    }

    public static org.apache.kafka.connect.data.Schema getOptionalKafkaConnectSchema(org.apache.pulsar.client.api.Schema pulsarSchema, boolean useOptionalPrimitives) {
        return PulsarSchemaToKafkaSchema.makeOptional(PulsarSchemaToKafkaSchema.getKafkaConnectSchema(pulsarSchema, useOptionalPrimitives));
    }

    public static org.apache.kafka.connect.data.Schema getKafkaConnectSchema(org.apache.pulsar.client.api.Schema pulsarSchema, boolean useOptionalPrimitives) {
        if (pulsarSchema == null || pulsarSchema.getSchemaInfo() == null) {
            throw PulsarSchemaToKafkaSchema.logAndThrowOnUnsupportedSchema(pulsarSchema, "Schema is required.", null);
        }
        String logicalSchemaName = pulsarSchema.getSchemaInfo().getName();
        if (kafkaLogicalSchemas.contains((Object)logicalSchemaName)) {
            if ("org.apache.kafka.connect.data.Timestamp".equals(logicalSchemaName)) {
                return Timestamp.SCHEMA;
            }
            if ("org.apache.kafka.connect.data.Date".equals(logicalSchemaName)) {
                return Date.SCHEMA;
            }
            if ("org.apache.kafka.connect.data.Time".equals(logicalSchemaName)) {
                return Time.SCHEMA;
            }
            if ("org.apache.kafka.connect.data.Decimal".equals(logicalSchemaName)) {
                int scale;
                String scaleString = null;
                if (pulsarSchema.getSchemaInfo().getProperties() != null) {
                    scaleString = (String)pulsarSchema.getSchemaInfo().getProperties().get("scale");
                }
                if (scaleString == null) {
                    throw new DataException("Invalid Decimal schema: scale parameter not found.");
                }
                try {
                    scale = Integer.parseInt(scaleString);
                }
                catch (NumberFormatException nfe) {
                    throw new DataException("Invalid scale parameter found in Decimal schema: ", (Throwable)nfe);
                }
                return Decimal.schema((int)scale);
            }
            throw new IllegalStateException("Unsupported Kafka Logical Schema " + logicalSchemaName);
        }
        if (useOptionalPrimitives && pulsarSchemaTypeToOptionalKafkaSchema.containsKey((Object)pulsarSchema.getSchemaInfo().getType())) {
            return (org.apache.kafka.connect.data.Schema)pulsarSchemaTypeToOptionalKafkaSchema.get((Object)pulsarSchema.getSchemaInfo().getType());
        }
        if (pulsarSchemaTypeToKafkaSchema.containsKey((Object)pulsarSchema.getSchemaInfo().getType())) {
            return (org.apache.kafka.connect.data.Schema)pulsarSchemaTypeToKafkaSchema.get((Object)pulsarSchema.getSchemaInfo().getType());
        }
        try {
            return (org.apache.kafka.connect.data.Schema)schemaCache.get((Object)pulsarSchema.getSchemaInfo().getSchema(), () -> {
                if (pulsarSchema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
                    KeyValueSchema kvSchema = (KeyValueSchema)pulsarSchema;
                    return SchemaBuilder.map((org.apache.kafka.connect.data.Schema)PulsarSchemaToKafkaSchema.makeOptional(PulsarSchemaToKafkaSchema.getKafkaConnectSchema(kvSchema.getKeySchema(), useOptionalPrimitives)), (org.apache.kafka.connect.data.Schema)PulsarSchemaToKafkaSchema.makeOptional(PulsarSchemaToKafkaSchema.getKafkaConnectSchema(kvSchema.getValueSchema(), useOptionalPrimitives))).optional().build();
                }
                Schema avroSchema = PulsarSchemaToKafkaSchema.parseAvroSchema(new String(pulsarSchema.getSchemaInfo().getSchema(), StandardCharsets.UTF_8));
                return avroData.toConnectSchema(avroSchema);
            });
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException ee) {
            throw PulsarSchemaToKafkaSchema.logAndThrowOnUnsupportedSchema(pulsarSchema, "Failed to convert to Kafka Schema.", ee);
        }
    }

    private static IllegalStateException logAndThrowOnUnsupportedSchema(org.apache.pulsar.client.api.Schema pulsarSchema, String prefix, Throwable cause) {
        String msg = prefix + " Pulsar Schema: " + (pulsarSchema == null || pulsarSchema.getSchemaInfo() == null ? "null" : pulsarSchema.getSchemaInfo().toString());
        log.error(msg);
        return new IllegalStateException(msg, cause);
    }

    static {
        avroData = new AvroData(1000);
        schemaCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
        optionalSchemaCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
        pulsarSchemaTypeToKafkaSchema = ImmutableMap.builder().put((Object)SchemaType.BOOLEAN, (Object)org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA).put((Object)SchemaType.INT8, (Object)org.apache.kafka.connect.data.Schema.INT8_SCHEMA).put((Object)SchemaType.INT16, (Object)org.apache.kafka.connect.data.Schema.INT16_SCHEMA).put((Object)SchemaType.INT32, (Object)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).put((Object)SchemaType.INT64, (Object)org.apache.kafka.connect.data.Schema.INT64_SCHEMA).put((Object)SchemaType.FLOAT, (Object)org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA).put((Object)SchemaType.DOUBLE, (Object)org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA).put((Object)SchemaType.STRING, (Object)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).put((Object)SchemaType.BYTES, (Object)org.apache.kafka.connect.data.Schema.BYTES_SCHEMA).put((Object)SchemaType.DATE, (Object)Date.SCHEMA).build();
        pulsarSchemaTypeToOptionalKafkaSchema = ImmutableMap.builder().put((Object)SchemaType.BOOLEAN, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_BOOLEAN_SCHEMA).put((Object)SchemaType.INT8, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_INT8_SCHEMA).put((Object)SchemaType.INT16, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_INT16_SCHEMA).put((Object)SchemaType.INT32, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_INT32_SCHEMA).put((Object)SchemaType.INT64, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_INT64_SCHEMA).put((Object)SchemaType.FLOAT, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_FLOAT32_SCHEMA).put((Object)SchemaType.DOUBLE, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_FLOAT64_SCHEMA).put((Object)SchemaType.STRING, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_STRING_SCHEMA).put((Object)SchemaType.BYTES, (Object)org.apache.kafka.connect.data.Schema.OPTIONAL_BYTES_SCHEMA).build();
        kafkaLogicalSchemas = ImmutableSet.builder().add((Object)"org.apache.kafka.connect.data.Timestamp").add((Object)"org.apache.kafka.connect.data.Date").add((Object)"org.apache.kafka.connect.data.Time").add((Object)"org.apache.kafka.connect.data.Decimal").build();
    }

    private static class OptionalForcingSchema
    implements org.apache.kafka.connect.data.Schema {
        org.apache.kafka.connect.data.Schema sourceSchema;

        public OptionalForcingSchema(org.apache.kafka.connect.data.Schema sourceSchema) {
            this.sourceSchema = sourceSchema;
        }

        public Schema.Type type() {
            return this.sourceSchema.type();
        }

        public boolean isOptional() {
            return true;
        }

        public Object defaultValue() {
            return this.sourceSchema.defaultValue();
        }

        public String name() {
            return this.sourceSchema.name();
        }

        public Integer version() {
            return this.sourceSchema.version();
        }

        public String doc() {
            return this.sourceSchema.doc();
        }

        public Map<String, String> parameters() {
            return this.sourceSchema.parameters();
        }

        public org.apache.kafka.connect.data.Schema keySchema() {
            return this.sourceSchema.keySchema();
        }

        public org.apache.kafka.connect.data.Schema valueSchema() {
            return this.sourceSchema.valueSchema();
        }

        public List<Field> fields() {
            return this.sourceSchema.fields();
        }

        public Field field(String s) {
            return this.sourceSchema.field(s);
        }

        public org.apache.kafka.connect.data.Schema schema() {
            return this.sourceSchema.schema();
        }
    }
}

