/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.person.locale.zh;

import com.google.inject.Inject;
import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.DateProducer;
import io.codearte.jfairy.producer.TimeProvider;
import io.codearte.jfairy.producer.person.NationalIdentityCardNumberProvider;
import io.codearte.jfairy.producer.util.ZhFairyUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ZhNationalIdentityCardNumberProvider
implements NationalIdentityCardNumberProvider {
    private static final int ORDER_MAX = 9999;
    private static DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private final BaseProducer baseProducer;
    private final DateProducer dateProducer;

    @Inject
    public ZhNationalIdentityCardNumberProvider(BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
        this.dateProducer = new DateProducer(baseProducer, new TimeProvider());
    }

    @Override
    public String get() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(this.baseProducer.randomElement(ZhFairyUtil.PROV_LIST));
        idBuilder.append(ZhFairyUtil.getRandomNumStr(this.baseProducer, 30, 2));
        idBuilder.append(ZhFairyUtil.getRandomNumStr(this.baseProducer, 12, 2));
        idBuilder.append(this.getBirthDate());
        idBuilder.append(ZhFairyUtil.getRandomNumStr(this.baseProducer, 9999, 4));
        return idBuilder.toString();
    }

    private String getBirthDate() {
        DateTime birthDate = this.dateProducer.randomDateInThePast(50);
        return formatter.print((ReadableInstant)birthDate);
    }
}

