/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.person.locale.sv;

import com.google.inject.Inject;
import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.DateProducer;
import io.codearte.jfairy.producer.person.NationalIdentificationNumber;
import io.codearte.jfairy.producer.person.NationalIdentificationNumberProperties;
import io.codearte.jfairy.producer.person.NationalIdentificationNumberProvider;
import io.codearte.jfairy.producer.person.Person;
import org.joda.time.DateTime;

public class SvNationalIdentificationNumberProvider
implements NationalIdentificationNumberProvider {
    private static final int NATIONAL_IDENTIFICATION_NUMBER_LENGTH = 11;
    private static final int VALIDITY_IN_YEARS = 120;
    private static final int[] WEIGHTS = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};
    private static final int MAX_SERIAL_NUMBER = 99;
    private static final int TEN = 10;
    private static final int[] SEX_FIELDS = new int[]{0, 2, 4, 6, 8};
    private final BaseProducer baseProducer;
    private final DateProducer dateProducer;
    private DateTime issueDate;
    private Person.Sex sex;

    @Inject
    public SvNationalIdentificationNumberProvider(DateProducer dateProducer, BaseProducer baseProducer, NationalIdentificationNumberProperties.Property ... properties) {
        this.dateProducer = dateProducer;
        this.baseProducer = baseProducer;
        this.with(properties);
    }

    public void with(NationalIdentificationNumberProperties.Property[] properties) {
        for (NationalIdentificationNumberProperties.Property property : properties) {
            property.apply(this);
        }
    }

    @Override
    public NationalIdentificationNumber get() {
        if (this.issueDate == null) {
            this.issueDate = this.dateProducer.randomDateInThePast(120);
        }
        if (this.sex == null) {
            this.sex = this.baseProducer.trueOrFalse() ? Person.Sex.MALE : Person.Sex.FEMALE;
        }
        return new NationalIdentificationNumber(this.generate());
    }

    private String generate() {
        int year = this.issueDate.getYearOfCentury();
        int month = this.issueDate.getMonthOfYear();
        int day = this.issueDate.getDayOfMonth();
        int serialNumber = this.baseProducer.randomInt(99);
        int sexCode = this.calculateSexCode(this.sex);
        String nationalIdentificationNumber = String.format("%02d%02d%02d-%02d%d", year, month, day, serialNumber, sexCode);
        return nationalIdentificationNumber + SvNationalIdentificationNumberProvider.calculateChecksum(nationalIdentificationNumber);
    }

    @Override
    public void setIssueDate(DateTime issueDate) {
        this.issueDate = issueDate;
    }

    @Override
    public void setSex(Person.Sex sex) {
        this.sex = sex;
    }

    public static boolean isValid(String nationalIdentificationNumber) {
        int size = nationalIdentificationNumber.length();
        if (size != 11) {
            return false;
        }
        int checksum = Integer.valueOf(nationalIdentificationNumber.substring(size - 1));
        int checkDigit = SvNationalIdentificationNumberProvider.calculateChecksum(nationalIdentificationNumber);
        return checkDigit == checksum;
    }

    private int calculateSexCode(Person.Sex sex) {
        return SEX_FIELDS[this.baseProducer.randomInt(SEX_FIELDS.length - 1)] + (sex == Person.Sex.MALE ? 1 : 0);
    }

    public static int calculateChecksum(String nationalIdentificationNumber) {
        String nationalIdentificationNumberWithoutHyphen = nationalIdentificationNumber.replace("-", "");
        int sum = 0;
        int i = 0;
        for (int weight : WEIGHTS) {
            int digit = Character.digit(nationalIdentificationNumberWithoutHyphen.charAt(i++), 10);
            int product = digit * weight;
            sum += product / 10 + product % 10;
        }
        if (sum % 10 == 0) {
            return 0;
        }
        return 10 - sum % 10;
    }
}

