/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.person.locale.en;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.person.NationalIdentityCardNumberProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EnNationalIdentityCardNumberProvider
implements NationalIdentityCardNumberProvider {
    private static final int SSN_LENGTH = 11;
    private static final int AREA_NUMBER_LENGTH = 3;
    private static final int GROUP_NUMBER_LENGTH = 2;
    private static final int GROUP_NUMBER_INDEX = 4;
    private static final List<Integer> HYPHEN_INDEXES = Lists.newArrayList((Object[])new Integer[]{3, 6});
    private static final int SERIAL_NUMBER_LENGTH = 4;
    private static final int SERIAL_NUMBER_INDEX = 7;
    private final BaseProducer baseProducer;

    @Inject
    public EnNationalIdentityCardNumberProvider(BaseProducer baseProducer) {
        this.baseProducer = baseProducer;
    }

    @Override
    public String get() {
        char[] ssn = new char[11];
        this.fillHyphens(ssn);
        this.fillAreaNumber(ssn);
        this.fillGroupNumber(ssn);
        this.fillSerialNumber(ssn);
        return String.valueOf(ssn);
    }

    private void fillHyphens(char[] ssn) {
        for (Integer index : HYPHEN_INDEXES) {
            ssn[index.intValue()] = 45;
        }
    }

    private void fillAreaNumber(char[] ssn) {
        String number;
        while ((number = String.valueOf(this.baseProducer.randomBetween(1, 899))).equals("666")) {
        }
        char[] digits = StringUtils.leftPad((String)number, (int)3, (String)"0").toCharArray();
        System.arraycopy(digits, 0, ssn, 0, digits.length);
    }

    private void fillGroupNumber(char[] ssn) {
        String number = String.valueOf(this.baseProducer.randomBetween(1, 99));
        char[] digits = StringUtils.leftPad((String)number, (int)2, (String)"0").toCharArray();
        System.arraycopy(digits, 0, ssn, 4, digits.length);
    }

    private void fillSerialNumber(char[] ssn) {
        String number = String.valueOf(this.baseProducer.randomBetween(1, 9999));
        char[] digits = StringUtils.leftPad((String)number, (int)4, (String)"0").toCharArray();
        System.arraycopy(digits, 0, ssn, 7, digits.length);
    }
}

