/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.person;

import com.google.inject.Provider;
import io.codearte.jfairy.data.DataMaster;
import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.util.TextUtils;
import org.apache.commons.lang3.StringUtils;

public class EmailProvider
implements Provider<String> {
    private final DataMaster dataMaster;
    private final BaseProducer baseProducer;
    private final String firstName;
    private final String lastName;

    public EmailProvider(DataMaster dataMaster, BaseProducer baseProducer, String firstName, String lastName) {
        this.dataMaster = dataMaster;
        this.baseProducer = baseProducer;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String get() {
        String prefix = "";
        switch (this.baseProducer.randomBetween(1, 3)) {
            case 1: {
                prefix = StringUtils.replace((String)(this.firstName + this.lastName), (String)" ", (String)"");
                break;
            }
            case 2: {
                prefix = StringUtils.replace((String)(this.firstName + "." + this.lastName), (String)" ", (String)".");
                break;
            }
            case 3: {
                prefix = StringUtils.replace((String)this.lastName, (String)" ", (String)"");
            }
        }
        return TextUtils.stripAccents(StringUtils.lowerCase((String)(prefix + '@' + this.dataMaster.getRandomValue("personalEmails"))));
    }
}

