/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy.producer.net;

import io.codearte.jfairy.producer.net.IPNumberProducer;
import javax.inject.Inject;

public class NetworkProducer {
    private final IPNumberProducer ipNumberProducer;

    @Inject
    public NetworkProducer(IPNumberProducer ipNumberProducer) {
        this.ipNumberProducer = ipNumberProducer;
    }

    public String ipAddress() {
        return this.ipNumberProducer.generate();
    }

    public String url(boolean isHttps) {
        String mergedIP = this.ipAddress().replaceAll("\\.", "");
        char[] domainChars = mergedIP.toCharArray();
        for (int i = 0; i < domainChars.length; ++i) {
            char c = domainChars[i];
            domainChars[i] = (char)(c + 97);
        }
        String domain = String.valueOf(domainChars);
        if (isHttps) {
            return "https://" + domain + ".com";
        }
        return "http://" + domain + ".com";
    }
}

