/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.jfairy;

import com.google.inject.Provider;
import io.codearte.jfairy.Bootstrap;
import io.codearte.jfairy.data.DataMaster;
import io.codearte.jfairy.producer.BaseProducer;
import io.codearte.jfairy.producer.DateProducer;
import io.codearte.jfairy.producer.company.Company;
import io.codearte.jfairy.producer.company.CompanyFactory;
import io.codearte.jfairy.producer.company.CompanyProperties;
import io.codearte.jfairy.producer.net.NetworkProducer;
import io.codearte.jfairy.producer.payment.CreditCard;
import io.codearte.jfairy.producer.payment.CreditCardProvider;
import io.codearte.jfairy.producer.person.Person;
import io.codearte.jfairy.producer.person.PersonFactory;
import io.codearte.jfairy.producer.person.PersonProperties;
import io.codearte.jfairy.producer.text.TextProducer;
import java.util.Locale;
import javax.inject.Inject;

public final class Fairy {
    private final TextProducer textProducer;
    private final PersonFactory personFactory;
    private final NetworkProducer networkProducer;
    private final BaseProducer baseProducer;
    private final DateProducer dateProducer;
    private final CreditCardProvider creditCardProvider;
    private final CompanyFactory companyFactory;

    @Inject
    Fairy(TextProducer textProducer, PersonFactory personFactory, NetworkProducer networkProducer, BaseProducer baseProducer, DateProducer dateProducer, CreditCardProvider creditCardProvider, CompanyFactory companyFactory) {
        this.textProducer = textProducer;
        this.personFactory = personFactory;
        this.networkProducer = networkProducer;
        this.baseProducer = baseProducer;
        this.dateProducer = dateProducer;
        this.creditCardProvider = creditCardProvider;
        this.companyFactory = companyFactory;
    }

    public static Fairy create() {
        return Bootstrap.create();
    }

    public static Fairy create(Locale locale) {
        return Bootstrap.create(locale);
    }

    public static Fairy create(Provider<DataMaster> dataMasterProvider, Locale locale) {
        return Bootstrap.create(dataMasterProvider, locale);
    }

    public static Bootstrap.Builder builder() {
        return Bootstrap.builder();
    }

    public TextProducer textProducer() {
        return this.textProducer;
    }

    public Person person(PersonProperties.PersonProperty ... personProperties) {
        return this.personFactory.producePersonProvider(personProperties).get();
    }

    public Company company(CompanyProperties.CompanyProperty ... companyProperties) {
        return this.companyFactory.produceCompany(companyProperties).get();
    }

    public BaseProducer baseProducer() {
        return this.baseProducer;
    }

    public DateProducer dateProducer() {
        return this.dateProducer;
    }

    public CreditCard creditCard() {
        return this.creditCardProvider.get();
    }

    public NetworkProducer networkProducer() {
        return this.networkProducer;
    }
}

