/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.operation;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.operation.HLLPolicy;
import com.aerospike.client.util.Packer;
import java.util.List;

public final class HLLOperation {
    private static final int INIT = 0;
    private static final int ADD = 1;
    private static final int SET_UNION = 2;
    private static final int SET_COUNT = 3;
    private static final int FOLD = 4;
    private static final int COUNT = 50;
    private static final int UNION = 51;
    private static final int UNION_COUNT = 52;
    private static final int INTERSECT_COUNT = 53;
    private static final int SIMILARITY = 54;
    private static final int DESCRIBE = 55;

    public static Operation init(HLLPolicy policy, String binName, int indexBitCount) {
        return HLLOperation.init(policy, binName, indexBitCount, -1);
    }

    public static Operation init(HLLPolicy policy, String binName, int indexBitCount, int minHashBitCount) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 0, 3);
        packer.packInt(indexBitCount);
        packer.packInt(minHashBitCount);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation add(HLLPolicy policy, String binName, List<Value> list) {
        return HLLOperation.add(policy, binName, list, -1, -1);
    }

    public static Operation add(HLLPolicy policy, String binName, List<Value> list, int indexBitCount) {
        return HLLOperation.add(policy, binName, list, indexBitCount, -1);
    }

    public static Operation add(HLLPolicy policy, String binName, List<Value> list, int indexBitCount, int minHashBitCount) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 1, 4);
        packer.packValueList(list);
        packer.packInt(indexBitCount);
        packer.packInt(minHashBitCount);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation setUnion(HLLPolicy policy, String binName, List<Value.HLLValue> list) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 2, 2);
        packer.packList(list);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation refreshCount(String binName) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 3, 0);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation fold(String binName, int indexBitCount) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 4, 1);
        packer.packInt(indexBitCount);
        return new Operation(Operation.Type.HLL_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation getCount(String binName) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 50, 0);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(packer.toByteArray()));
    }

    public static Operation getUnion(String binName, List<Value.HLLValue> list) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 51, 1);
        packer.packList(list);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(packer.toByteArray()));
    }

    public static Operation getUnionCount(String binName, List<Value.HLLValue> list) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 52, 1);
        packer.packList(list);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(packer.toByteArray()));
    }

    public static Operation getIntersectCount(String binName, List<Value.HLLValue> list) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 53, 1);
        packer.packList(list);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(packer.toByteArray()));
    }

    public static Operation getSimilarity(String binName, List<Value.HLLValue> list) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 54, 1);
        packer.packList(list);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(packer.toByteArray()));
    }

    public static Operation describe(String binName) {
        Packer packer = new Packer();
        HLLOperation.init(packer, 55, 0);
        return new Operation(Operation.Type.HLL_READ, binName, Value.get(packer.toByteArray()));
    }

    private static void init(Packer packer, int command, int count) {
        packer.packArrayBegin(count + 1);
        packer.packInt(command);
    }
}

