/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.operation;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.operation.BitOverflowAction;
import com.aerospike.client.operation.BitPolicy;
import com.aerospike.client.util.Packer;

public final class BitOperation {
    private static final int RESIZE = 0;
    private static final int INSERT = 1;
    private static final int REMOVE = 2;
    private static final int SET = 3;
    private static final int OR = 4;
    private static final int XOR = 5;
    private static final int AND = 6;
    private static final int NOT = 7;
    private static final int LSHIFT = 8;
    private static final int RSHIFT = 9;
    private static final int ADD = 10;
    private static final int SUBTRACT = 11;
    private static final int SET_INT = 12;
    private static final int GET = 50;
    private static final int COUNT = 51;
    private static final int LSCAN = 52;
    private static final int RSCAN = 53;
    private static final int GET_INT = 54;
    private static final int INT_FLAGS_SIGNED = 1;

    public static Operation resize(BitPolicy policy, String binName, int byteSize, int resizeFlags) {
        return BitOperation.createOperation(0, Operation.Type.BIT_MODIFY, binName, byteSize, policy.flags, resizeFlags);
    }

    public static Operation insert(BitPolicy policy, String binName, int byteOffset, byte[] value) {
        Packer packer = new Packer();
        BitOperation.init(packer, 1, 3);
        packer.packInt(byteOffset);
        packer.packBytes(value);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation remove(BitPolicy policy, String binName, int byteOffset, int byteSize) {
        return BitOperation.createOperation(2, Operation.Type.BIT_MODIFY, binName, byteOffset, byteSize, policy.flags);
    }

    public static Operation set(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        return BitOperation.createOperation(3, Operation.Type.BIT_MODIFY, binName, bitOffset, bitSize, value, policy.flags);
    }

    public static Operation or(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        return BitOperation.createOperation(4, Operation.Type.BIT_MODIFY, binName, bitOffset, bitSize, value, policy.flags);
    }

    public static Operation xor(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        return BitOperation.createOperation(5, Operation.Type.BIT_MODIFY, binName, bitOffset, bitSize, value, policy.flags);
    }

    public static Operation and(BitPolicy policy, String binName, int bitOffset, int bitSize, byte[] value) {
        return BitOperation.createOperation(6, Operation.Type.BIT_MODIFY, binName, bitOffset, bitSize, value, policy.flags);
    }

    public static Operation not(BitPolicy policy, String binName, int bitOffset, int bitSize) {
        return BitOperation.createOperation(7, Operation.Type.BIT_MODIFY, binName, bitOffset, bitSize, policy.flags);
    }

    public static Operation lshift(BitPolicy policy, String binName, int bitOffset, int bitSize, int shift) {
        return BitOperation.createOperation(8, Operation.Type.BIT_MODIFY, binName, bitOffset, bitSize, shift, policy.flags);
    }

    public static Operation rshift(BitPolicy policy, String binName, int bitOffset, int bitSize, int shift) {
        return BitOperation.createOperation(9, Operation.Type.BIT_MODIFY, binName, bitOffset, bitSize, shift, policy.flags);
    }

    public static Operation add(BitPolicy policy, String binName, int bitOffset, int bitSize, long value, boolean signed, BitOverflowAction action) {
        return BitOperation.createMathOperation(10, policy, binName, bitOffset, bitSize, value, signed, action);
    }

    public static Operation subtract(BitPolicy policy, String binName, int bitOffset, int bitSize, long value, boolean signed, BitOverflowAction action) {
        return BitOperation.createMathOperation(11, policy, binName, bitOffset, bitSize, value, signed, action);
    }

    public static Operation setInt(BitPolicy policy, String binName, int bitOffset, int bitSize, long value) {
        Packer packer = new Packer();
        BitOperation.init(packer, 12, 4);
        packer.packInt(bitOffset);
        packer.packInt(bitSize);
        packer.packLong(value);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation get(String binName, int bitOffset, int bitSize) {
        return BitOperation.createOperation(50, Operation.Type.BIT_READ, binName, bitOffset, bitSize);
    }

    public static Operation count(String binName, int bitOffset, int bitSize) {
        return BitOperation.createOperation(51, Operation.Type.BIT_READ, binName, bitOffset, bitSize);
    }

    public static Operation lscan(String binName, int bitOffset, int bitSize, boolean value) {
        return BitOperation.createOperation(52, Operation.Type.BIT_READ, binName, bitOffset, bitSize, value);
    }

    public static Operation rscan(String binName, int bitOffset, int bitSize, boolean value) {
        return BitOperation.createOperation(53, Operation.Type.BIT_READ, binName, bitOffset, bitSize, value);
    }

    public static Operation getInt(String binName, int bitOffset, int bitSize, boolean signed) {
        Packer packer = new Packer();
        BitOperation.init(packer, 54, signed ? 3 : 2);
        packer.packInt(bitOffset);
        packer.packInt(bitSize);
        if (signed) {
            packer.packInt(1);
        }
        return new Operation(Operation.Type.BIT_READ, binName, Value.get(packer.toByteArray()));
    }

    private static Operation createOperation(int command, Operation.Type type, String binName, int v1, int v2) {
        Packer packer = new Packer();
        BitOperation.init(packer, command, 2);
        packer.packInt(v1);
        packer.packInt(v2);
        return new Operation(type, binName, Value.get(packer.toByteArray()));
    }

    private static Operation createOperation(int command, Operation.Type type, String binName, int v1, int v2, boolean v3) {
        Packer packer = new Packer();
        BitOperation.init(packer, command, 3);
        packer.packInt(v1);
        packer.packInt(v2);
        packer.packBoolean(v3);
        return new Operation(type, binName, Value.get(packer.toByteArray()));
    }

    private static Operation createOperation(int command, Operation.Type type, String binName, int v1, int v2, int v3) {
        Packer packer = new Packer();
        BitOperation.init(packer, command, 3);
        packer.packInt(v1);
        packer.packInt(v2);
        packer.packInt(v3);
        return new Operation(type, binName, Value.get(packer.toByteArray()));
    }

    private static Operation createOperation(int command, Operation.Type type, String binName, int v1, int v2, int v3, int v4) {
        Packer packer = new Packer();
        BitOperation.init(packer, command, 4);
        packer.packInt(v1);
        packer.packInt(v2);
        packer.packInt(v3);
        packer.packInt(v4);
        return new Operation(type, binName, Value.get(packer.toByteArray()));
    }

    private static Operation createOperation(int command, Operation.Type type, String binName, int v1, int v2, byte[] v3, int v4) {
        Packer packer = new Packer();
        BitOperation.init(packer, command, 4);
        packer.packInt(v1);
        packer.packInt(v2);
        packer.packBytes(v3);
        packer.packInt(v4);
        return new Operation(type, binName, Value.get(packer.toByteArray()));
    }

    private static Operation createMathOperation(int command, BitPolicy policy, String binName, int bitOffset, int bitSize, long value, boolean signed, BitOverflowAction action) {
        Packer packer = new Packer();
        BitOperation.init(packer, command, 5);
        packer.packInt(bitOffset);
        packer.packInt(bitSize);
        packer.packLong(value);
        packer.packInt(policy.flags);
        int flags = action.flags;
        if (signed) {
            flags |= 1;
        }
        packer.packInt(flags);
        return new Operation(Operation.Type.BIT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    private static void init(Packer packer, int command, int count) {
        packer.packArrayBegin(count + 1);
        packer.packInt(command);
    }
}

