/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.util.Crypto;
import java.util.Arrays;

public final class Key {
    public final String namespace;
    public final String setName;
    public final byte[] digest;
    public final Value userKey;

    public Key(String namespace, String setName, String key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = new Value.StringValue(key);
        this.digest = Crypto.computeDigest(setName, this.userKey);
    }

    public Key(String namespace, String setName, byte[] key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = new Value.BytesValue(key);
        this.digest = Crypto.computeDigest(setName, this.userKey);
    }

    public Key(String namespace, String setName, byte[] key, int offset, int length) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = new Value.ByteSegmentValue(key, offset, length);
        this.digest = Crypto.computeDigest(setName, this.userKey);
    }

    public Key(String namespace, String setName, int key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = new Value.LongValue(key);
        this.digest = Crypto.computeDigest(setName, this.userKey);
    }

    public Key(String namespace, String setName, long key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = new Value.LongValue(key);
        this.digest = Crypto.computeDigest(setName, this.userKey);
    }

    public Key(String namespace, String setName, Value key) throws AerospikeException {
        this.namespace = namespace;
        this.setName = setName;
        this.userKey = key;
        key.validateKeyType();
        this.digest = Crypto.computeDigest(setName, key);
    }

    public Key(String namespace, byte[] digest, String setName, Value userKey) {
        this.namespace = namespace;
        this.digest = digest;
        this.setName = setName;
        this.userKey = userKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.digest);
        return 31 * result + this.namespace.hashCode();
    }

    public boolean equals(Object obj) {
        Key other = (Key)obj;
        if (!Arrays.equals(this.digest, other.digest)) {
            return false;
        }
        return this.namespace.equals(other.namespace);
    }

    public static byte[] computeDigest(String setName, Value key) throws AerospikeException {
        return Crypto.computeDigest(setName, key);
    }

    public String toString() {
        return this.namespace + ":" + this.setName + ":" + this.userKey + ":" + Buffer.bytesToHexString(this.digest);
    }
}

