/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Upvaldesc;
import org.luaj.vm2.compiler.FuncState;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.LexState;

public class LuaC
extends Lua
implements Globals.Compiler,
Globals.Loader {
    public static final LuaC instance = new LuaC();
    public static final int MAXSTACK = 250;
    static final int LUAI_MAXUPVAL = 255;
    static final int LUAI_MAXVARS = 200;
    static final int NO_REG = 255;
    static final int iABC = 0;
    static final int iABx = 1;
    static final int iAsBx = 2;
    static final int OpArgN = 0;
    static final int OpArgU = 1;
    static final int OpArgR = 2;
    static final int OpArgK = 3;
    public int nCcalls;
    Hashtable strings;

    public static void install(Globals globals) {
        globals.compiler = instance;
        globals.loader = instance;
    }

    protected static void _assert(boolean bl) {
        if (!bl) {
            throw new LuaError("compiler assert failed");
        }
    }

    static void SET_OPCODE(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFFFC0 | n << 0 & 0x3F);
    }

    static void SETARG_A(int[] nArray, int n, int n2) {
        nArray[n] = nArray[n] & 0xFFFFC03F | n2 << 6 & 0x3FC0;
    }

    static void SETARG_A(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFC03F | n << 6 & 0x3FC0);
    }

    static void SETARG_B(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x7FFFFF | n << 23 & 0xFF800000);
    }

    static void SETARG_C(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFF803FFF | n << 14 & 0x7FC000);
    }

    static void SETARG_Bx(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x3FFF | n << 14 & 0xFFFFC000);
    }

    static void SETARG_sBx(InstructionPtr instructionPtr, int n) {
        LuaC.SETARG_Bx(instructionPtr, n + 131071);
    }

    static int CREATE_ABC(int n, int n2, int n3, int n4) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 23 & 0xFF800000 | n4 << 14 & 0x7FC000;
    }

    static int CREATE_ABx(int n, int n2, int n3) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 14 & 0xFFFFC000;
    }

    static LuaValue[] realloc(LuaValue[] luaValueArray, int n) {
        LuaValue[] luaValueArray2 = new LuaValue[n];
        if (luaValueArray != null) {
            System.arraycopy(luaValueArray, 0, luaValueArray2, 0, Math.min(luaValueArray.length, n));
        }
        return luaValueArray2;
    }

    static Prototype[] realloc(Prototype[] prototypeArray, int n) {
        Prototype[] prototypeArray2 = new Prototype[n];
        if (prototypeArray != null) {
            System.arraycopy(prototypeArray, 0, prototypeArray2, 0, Math.min(prototypeArray.length, n));
        }
        return prototypeArray2;
    }

    static LuaString[] realloc(LuaString[] luaStringArray, int n) {
        LuaString[] luaStringArray2 = new LuaString[n];
        if (luaStringArray != null) {
            System.arraycopy(luaStringArray, 0, luaStringArray2, 0, Math.min(luaStringArray.length, n));
        }
        return luaStringArray2;
    }

    static LocVars[] realloc(LocVars[] locVarsArray, int n) {
        LocVars[] locVarsArray2 = new LocVars[n];
        if (locVarsArray != null) {
            System.arraycopy(locVarsArray, 0, locVarsArray2, 0, Math.min(locVarsArray.length, n));
        }
        return locVarsArray2;
    }

    static Upvaldesc[] realloc(Upvaldesc[] upvaldescArray, int n) {
        Upvaldesc[] upvaldescArray2 = new Upvaldesc[n];
        if (upvaldescArray != null) {
            System.arraycopy(upvaldescArray, 0, upvaldescArray2, 0, Math.min(upvaldescArray.length, n));
        }
        return upvaldescArray2;
    }

    static LexState.Vardesc[] realloc(LexState.Vardesc[] vardescArray, int n) {
        LexState.Vardesc[] vardescArray2 = new LexState.Vardesc[n];
        if (vardescArray != null) {
            System.arraycopy(vardescArray, 0, vardescArray2, 0, Math.min(vardescArray.length, n));
        }
        return vardescArray2;
    }

    static LexState.Labeldesc[] grow(LexState.Labeldesc[] labeldescArray, int n) {
        return labeldescArray == null ? new LexState.Labeldesc[2] : (labeldescArray.length < n ? LuaC.realloc(labeldescArray, labeldescArray.length * 2) : labeldescArray);
    }

    static LexState.Labeldesc[] realloc(LexState.Labeldesc[] labeldescArray, int n) {
        LexState.Labeldesc[] labeldescArray2 = new LexState.Labeldesc[n];
        if (labeldescArray != null) {
            System.arraycopy(labeldescArray, 0, labeldescArray2, 0, Math.min(labeldescArray.length, n));
        }
        return labeldescArray2;
    }

    static int[] realloc(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        }
        return nArray2;
    }

    static byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        }
        return byArray2;
    }

    static char[] realloc(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        if (cArray != null) {
            System.arraycopy(cArray, 0, cArray2, 0, Math.min(cArray.length, n));
        }
        return cArray2;
    }

    protected LuaC() {
    }

    private LuaC(Hashtable hashtable) {
        this.strings = hashtable;
    }

    public Prototype compile(InputStream inputStream, String string) throws IOException {
        return new LuaC(new Hashtable()).luaY_parser(inputStream, string);
    }

    public LuaValue load(InputStream inputStream, String string, Globals globals) throws IOException {
        return new LuaClosure(this.compile(inputStream, string), globals);
    }

    private Prototype luaY_parser(InputStream inputStream, String string) throws IOException {
        FuncState funcState;
        LexState lexState = new LexState(this, inputStream);
        lexState.fs = funcState = new FuncState();
        lexState.setinput(this, inputStream.read(), inputStream, LuaValue.valueOf(string));
        funcState.f = new Prototype();
        funcState.f.source = LuaValue.valueOf(string);
        lexState.mainfunc(funcState);
        LuaC._assert(funcState.prev == null);
        LuaC._assert(lexState.dyd == null || lexState.dyd.n_actvar == 0 && lexState.dyd.n_gt == 0 && lexState.dyd.n_label == 0);
        return funcState.f;
    }

    public LuaString newTString(String string) {
        return this.cachedLuaString(LuaString.valueOf(string));
    }

    public LuaString newTString(LuaString luaString) {
        return this.cachedLuaString(luaString);
    }

    public LuaString cachedLuaString(LuaString luaString) {
        LuaString luaString2 = (LuaString)this.strings.get(luaString);
        if (luaString2 != null) {
            return luaString2;
        }
        this.strings.put(luaString, luaString);
        return luaString;
    }

    public String pushfstring(String string) {
        return string;
    }

    public LuaFunction load(Prototype prototype, String string, LuaValue luaValue) throws IOException {
        return new LuaClosure(prototype, luaValue);
    }
}

