/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum ClientAuth {
    WANT("Want", "Requests the client certificate on handshake and validates if present but does not require it"),
    REQUIRED("Required", "Requests the client certificate on handshake and rejects the connection if it is not present and valid"),
    NONE("None", "Does not request the client certificate on handshake");

    private final String type;
    private final String description;

    private ClientAuth(String type, String description) {
        this.type = type;
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[SslContextFactory]");
        sb.append("type=").append(this.type);
        sb.append("description=").append(this.description);
        return sb.toString();
    }

    public static boolean isValidClientAuthType(String type) {
        if (type == null || type.replaceAll("\\s", "").isEmpty()) {
            return false;
        }
        return Arrays.stream(ClientAuth.values()).map(ca -> ca.getType().toLowerCase()).collect(Collectors.toList()).contains(type.toLowerCase());
    }
}

