/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import java.util.HashMap;
import java.util.Map;
import jpt.sun.tools.javac.util.DiagnosticSource;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt30.tools.JavaFileObject;

public abstract class AbstractLog {
    public final JCDiagnostic.Factory diags;
    protected DiagnosticSource source;
    protected Map<JavaFileObject, DiagnosticSource> sourceMap;

    AbstractLog(JCDiagnostic.Factory diags) {
        this.diags = diags;
        this.sourceMap = new HashMap<JavaFileObject, DiagnosticSource>();
    }

    public JavaFileObject useSource(JavaFileObject file) {
        JavaFileObject prev = this.source == null ? null : this.source.getFile();
        this.source = this.getSource(file);
        return prev;
    }

    protected DiagnosticSource getSource(JavaFileObject file) {
        if (file == null) {
            return DiagnosticSource.NO_SOURCE;
        }
        DiagnosticSource s = this.sourceMap.get(file);
        if (s == null) {
            s = new DiagnosticSource(file, this);
            this.sourceMap.put(file, s);
        }
        return s;
    }

    public DiagnosticSource currentSource() {
        return this.source;
    }

    public void error(String key, Object ... args) {
        this.error(this.diags.errorKey(key, args));
    }

    public void error(JCDiagnostic.Error errorKey) {
        this.report(this.diags.error(null, this.source, null, errorKey));
    }

    public void error(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Error errorKey) {
        this.report(this.diags.error(null, this.source, pos, errorKey));
    }

    public void error(JCDiagnostic.DiagnosticFlag flag, JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Error errorKey) {
        this.report(this.diags.error(flag, this.source, pos, errorKey));
    }

    public void error(int pos, String key, Object ... args) {
        this.error(pos, this.diags.errorKey(key, args));
    }

    public void error(int pos, JCDiagnostic.Error errorKey) {
        this.report(this.diags.error(null, this.source, this.wrap(pos), errorKey));
    }

    public void error(JCDiagnostic.DiagnosticFlag flag, int pos, JCDiagnostic.Error errorKey) {
        this.report(this.diags.error(flag, this.source, this.wrap(pos), errorKey));
    }

    public void warning(JCDiagnostic.Warning warningKey) {
        this.report(this.diags.warning(this.source, null, warningKey));
    }

    public void warning(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warningKey) {
        this.report(this.diags.warning(this.source, pos, warningKey));
    }

    public void warning(int pos, JCDiagnostic.Warning warningKey) {
        this.report(this.diags.warning(this.source, this.wrap(pos), warningKey));
    }

    public void mandatoryWarning(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warningKey) {
        this.report(this.diags.mandatoryWarning(this.source, pos, warningKey));
    }

    public void note(JCDiagnostic.Note noteKey) {
        this.report(this.diags.note(this.source, null, noteKey));
    }

    public void note(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Note noteKey) {
        this.report(this.diags.note(this.source, pos, noteKey));
    }

    public void note(int pos, JCDiagnostic.Note noteKey) {
        this.report(this.diags.note(this.source, this.wrap(pos), noteKey));
    }

    public void note(JavaFileObject file, JCDiagnostic.Note noteKey) {
        this.report(this.diags.note(this.getSource(file), null, noteKey));
    }

    public void mandatoryNote(JavaFileObject file, JCDiagnostic.Note noteKey) {
        this.report(this.diags.mandatoryNote(this.getSource(file), noteKey));
    }

    protected abstract void report(JCDiagnostic var1);

    protected abstract void directError(String var1, Object ... var2);

    private JCDiagnostic.DiagnosticPosition wrap(int pos) {
        return pos == -1 ? null : new JCDiagnostic.SimpleDiagnosticPosition(pos);
    }
}

