/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.processing;

import jpt.sun.tools.javac.model.JavacElements;
import jpt.sun.tools.javac.processing.JavacProcessingEnvironment;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Pair;
import jpt30.annotation.processing.Messager;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.AnnotationValue;
import jpt30.lang.model.element.Element;
import jpt30.tools.Diagnostic;
import jpt30.tools.JavaFileObject;

public class JavacMessager
implements Messager {
    Log log;
    JavacProcessingEnvironment processingEnv;
    int errorCount = 0;
    int warningCount = 0;

    JavacMessager(Context context, JavacProcessingEnvironment processingEnv) {
        this.log = Log.instance(context);
        this.processingEnv = processingEnv;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
        this.printMessage(kind, msg, null, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
        this.printMessage(kind, msg, e, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
        this.printMessage(kind, msg, e, a, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
        JavaFileObject oldSource = null;
        JavaFileObject newSource = null;
        JCDiagnostic.DiagnosticPosition pos = null;
        JavacElements elemUtils = this.processingEnv.getElementUtils();
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = elemUtils.getTreeAndTopLevel(e, a, v);
        if (treeTop != null && (newSource = ((JCTree.JCCompilationUnit)treeTop.snd).sourcefile) != null) {
            oldSource = this.log.useSource(newSource);
            pos = ((JCTree)treeTop.fst).pos();
        }
        try {
            switch (kind) {
                case ERROR: {
                    ++this.errorCount;
                    this.log.error(JCDiagnostic.DiagnosticFlag.API, pos, CompilerProperties.Errors.ProcMessager(msg.toString()));
                    break;
                }
                case WARNING: {
                    ++this.warningCount;
                    this.log.warning(pos, CompilerProperties.Warnings.ProcMessager(msg.toString()));
                    break;
                }
                case MANDATORY_WARNING: {
                    ++this.warningCount;
                    this.log.mandatoryWarning(pos, CompilerProperties.Warnings.ProcMessager(msg.toString()));
                    break;
                }
                default: {
                    this.log.note(pos, CompilerProperties.Notes.ProcMessager(msg.toString()));
                }
            }
            if (newSource == null) return;
        }
        catch (Throwable throwable) {
            if (newSource == null) throw throwable;
            this.log.useSource(oldSource);
            throw throwable;
        }
        this.log.useSource(oldSource);
    }

    public void printError(String msg) {
        this.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    public void printWarning(String msg) {
        this.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    public void printNotice(String msg) {
        this.printMessage(Diagnostic.Kind.NOTE, msg);
    }

    public boolean errorRaised() {
        return this.errorCount > 0;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public void newRound() {
        this.errorCount = 0;
    }

    public String toString() {
        return "javac Messager";
    }
}

