/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.netty.NettyIoServiceFactory;

public abstract class NettyIoService
extends AbstractCloseable
implements IoService {
    public static final AttributeKey<IoConnectFuture> CONNECT_FUTURE_KEY = AttributeKey.valueOf((String)IoConnectFuture.class.getName());
    protected final AtomicLong sessionSeq = new AtomicLong();
    protected final Map<Long, IoSession> sessions = new ConcurrentHashMap<Long, IoSession>();
    protected final ChannelGroup channelGroup;
    protected final NettyIoServiceFactory factory;
    protected final IoHandler handler;
    private boolean noMoreSessions;
    private IoServiceEventListener eventListener;

    protected NettyIoService(NettyIoServiceFactory factory, IoHandler handler, String channelGroupName) {
        this.factory = Objects.requireNonNull(factory, "No factory instance provided");
        this.handler = Objects.requireNonNull(handler, "No I/O handler provied");
        this.eventListener = factory.getIoServiceEventListener();
        this.channelGroup = new DefaultChannelGroup(Objects.requireNonNull(channelGroupName, "No channel group name"), (EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCloseImmediately() {
        NettyIoService nettyIoService = this;
        synchronized (nettyIoService) {
            this.noMoreSessions = true;
        }
        this.channelGroup.close();
        super.doCloseImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerChannel(Channel channel) throws CancellationException {
        NettyIoService nettyIoService = this;
        synchronized (nettyIoService) {
            if (this.noMoreSessions) {
                throw new CancellationException("NettyIoService closed");
            }
            this.channelGroup.add((Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapSession(IoSession session) throws CancellationException {
        NettyIoService nettyIoService = this;
        synchronized (nettyIoService) {
            if (this.noMoreSessions) {
                throw new CancellationException("NettyIoService closed; cannot register new session");
            }
            this.sessions.put(session.getId(), session);
        }
    }

    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    public Map<Long, IoSession> getManagedSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }
}

