/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.DecapsulateException;
import javax.crypto.KEM;
import org.apache.sshd.common.util.security.KEM;
import org.apache.sshd.common.util.security.KEMFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
enum JceKEM implements KEMFactory
{
    INSTANCE;

    private static final byte[] ML768_X509_PREFIX;
    private static final byte[] ML1024_X509_PREFIX;

    @Override
    public KEM get(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        javax.crypto.KEM kem;
        javax.crypto.KEM kEM = kem = provider == null ? javax.crypto.KEM.getInstance(algorithm) : javax.crypto.KEM.getInstance(algorithm, provider);
        if ("ML-KEM-768".equalsIgnoreCase(algorithm)) {
            return new KEMWrapper(kem, "ML-KEM-768", provider, 1184, 1088, ML768_X509_PREFIX);
        }
        if ("ML-KEM-1024".equalsIgnoreCase(algorithm)) {
            return new KEMWrapper(kem, "ML-KEM-1024", provider, 1568, 1568, ML1024_X509_PREFIX);
        }
        throw new NoSuchAlgorithmException(algorithm + " not supported");
    }

    @Override
    public boolean isSupported(String algorithm) {
        if ("ML-KEM-768".equalsIgnoreCase(algorithm) || "ML-KEM-1024".equalsIgnoreCase(algorithm)) {
            try {
                return javax.crypto.KEM.getInstance(algorithm) != null;
            }
            catch (NoSuchAlgorithmException e) {
                return false;
            }
        }
        return false;
    }

    static {
        ML768_X509_PREFIX = new byte[]{48, -126, 4, -78, 48, 11, 6, 9, 96, -122, 72, 1, 101, 3, 4, 4, 2, 3, -126, 4, -95, 0};
        ML1024_X509_PREFIX = new byte[]{48, -126, 6, 50, 48, 11, 6, 9, 96, -122, 72, 1, 101, 3, 4, 4, 3, 3, -126, 6, 33, 0};
    }

    private static class KEMWrapper
    implements KEM {
        private final javax.crypto.KEM kem;
        private final String algorithm;
        private final Provider provider;
        private final int encapKeyLength;
        private final int cipherTextLength;
        private final byte[] prefix;

        KEMWrapper(javax.crypto.KEM kem, String algorithm, Provider provider, int encapKeyLength, int cipherTextLength, byte[] prefix) {
            this.algorithm = algorithm;
            this.provider = provider;
            this.encapKeyLength = encapKeyLength;
            this.cipherTextLength = cipherTextLength;
            this.prefix = prefix;
            this.kem = kem;
        }

        public String toString() {
            return this.kem.getClass().getName();
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public Client getClient() {
            return new Client();
        }

        @Override
        public Server getServer() {
            return new Server();
        }

        private class Client
        implements KEM.Client {
            private KEM.Decapsulator dec;
            private byte[] pubKey;

            Client() {
            }

            private byte[] extractFromX509(byte[] x509, byte[] prefix, int length) {
                return Arrays.copyOfRange(x509, prefix.length, prefix.length + length);
            }

            @Override
            public void init() {
                try {
                    KeyPairGenerator generator = KEMWrapper.this.provider == null ? KeyPairGenerator.getInstance(KEMWrapper.this.algorithm) : KeyPairGenerator.getInstance(KEMWrapper.this.algorithm, KEMWrapper.this.provider);
                    KeyPair kp = generator.generateKeyPair();
                    this.dec = KEMWrapper.this.kem.newDecapsulator(kp.getPrivate());
                    this.pubKey = this.extractFromX509(kp.getPublic().getEncoded(), KEMWrapper.this.prefix, KEMWrapper.this.encapKeyLength);
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }

            @Override
            public byte[] getPublicKey() {
                return this.pubKey;
            }

            @Override
            public byte[] extractSecret(byte[] encapsulated) {
                try {
                    return this.dec.decapsulate(encapsulated).getEncoded();
                }
                catch (DecapsulateException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }

            @Override
            public int getEncapsulationLength() {
                return KEMWrapper.this.cipherTextLength;
            }
        }

        private class Server
        implements KEM.Server {
            private KEM.Encapsulated encapsulation;

            Server() {
            }

            private PublicKey createKey(byte[] raw, int from, int length) throws GeneralSecurityException {
                KeyFactory factory = KEMWrapper.this.provider == null ? KeyFactory.getInstance(KEMWrapper.this.algorithm) : KeyFactory.getInstance(KEMWrapper.this.algorithm, KEMWrapper.this.provider);
                byte[] x509 = Arrays.copyOf(KEMWrapper.this.prefix, KEMWrapper.this.prefix.length + length);
                System.arraycopy(raw, from, x509, KEMWrapper.this.prefix.length, length);
                return factory.generatePublic(new X509EncodedKeySpec(x509));
            }

            @Override
            public int getPublicKeyLength() {
                return KEMWrapper.this.encapKeyLength;
            }

            @Override
            public byte[] init(byte[] publicKey) {
                int pkBytes = this.getPublicKeyLength();
                if (publicKey.length < pkBytes) {
                    throw new IllegalArgumentException("KEM public key too short: " + publicKey.length);
                }
                try {
                    KEM.Encapsulator enc = KEMWrapper.this.kem.newEncapsulator(this.createKey(publicKey, 0, pkBytes));
                    this.encapsulation = enc.encapsulate();
                    return Arrays.copyOfRange(publicKey, pkBytes, publicKey.length);
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }

            @Override
            public byte[] getSecret() {
                return this.encapsulation.key().getEncoded();
            }

            @Override
            public byte[] getEncapsulation() {
                return this.encapsulation.encapsulation();
            }
        }
    }
}

