/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.coordinator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.coordinator.impl.CoordinationHolder;
import org.apache.felix.coordinator.impl.CoordinationImpl;
import org.apache.felix.coordinator.impl.CoordinatorImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationMgr {
    private ThreadLocal<Stack<CoordinationImpl>> perThreadStack = new ThreadLocal();
    private final AtomicLong ctr = new AtomicLong(-1L);
    private final Map<Long, CoordinationImpl> coordinations = new HashMap<Long, CoordinationImpl>();
    private final Map<Participant, CoordinationImpl> participants = new IdentityHashMap<Participant, CoordinationImpl>();
    private final Timer coordinationTimer = new Timer("Coordination Timer", true);
    private long participationTimeOut = 60000L;

    CoordinationMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() {
        this.coordinationTimer.purge();
        this.coordinationTimer.cancel();
        ArrayList<CoordinationImpl> coords = new ArrayList<CoordinationImpl>();
        Map<Object, CoordinationImpl> map = this.coordinations;
        synchronized (map) {
            coords.addAll(this.coordinations.values());
            this.coordinations.clear();
        }
        for (CoordinationImpl c : coords) {
            if (c.isTerminated()) continue;
            c.fail(Coordination.RELEASED);
        }
        map = this.participants;
        synchronized (map) {
            this.participants.clear();
        }
        this.perThreadStack = null;
    }

    private Stack<CoordinationImpl> getThreadStack(boolean create) {
        ThreadLocal<Stack<CoordinationImpl>> tl = this.perThreadStack;
        Stack<CoordinationImpl> stack = null;
        if (tl != null && (stack = tl.get()) == null && create) {
            stack = new Stack();
            tl.set(stack);
        }
        return stack;
    }

    void configure(long participationTimeout) {
        this.participationTimeOut = participationTimeout;
    }

    void schedule(TimerTask task, long deadLine) {
        if (deadLine < 0L) {
            task.cancel();
        } else {
            this.coordinationTimer.schedule(task, new Date(deadLine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockParticipant(Participant p, CoordinationImpl c) {
        Map<Participant, CoordinationImpl> map = this.participants;
        synchronized (map) {
            long completeWaitTime = this.participationTimeOut;
            long cutOff = System.currentTimeMillis() + completeWaitTime;
            CoordinationImpl current = this.participants.get(p);
            while (current != null && current != c) {
                long waitTime = completeWaitTime > 500L ? 500L : completeWaitTime;
                completeWaitTime -= waitTime;
                if (current.getThread() != null && current.getThread() == c.getThread()) {
                    throw new CoordinationException("Participant " + p + " already participating in Coordination " + current.getId() + "/" + current.getName() + " in this thread", c, 1);
                }
                try {
                    this.participants.wait(waitTime);
                }
                catch (InterruptedException ie) {
                    throw new CoordinationException("Interrupted waiting to add Participant " + p + " currently participating in Coordination " + current.getId() + "/" + current.getName() + " in this thread", c, 6);
                }
                if (System.currentTimeMillis() >= cutOff) {
                    throw new CoordinationException("Timed out waiting to join coordinaton", c, 2, Coordination.TIMEOUT);
                }
                current = this.participants.get(p);
            }
            this.participants.put(p, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseParticipant(Participant p) {
        Map<Participant, CoordinationImpl> map = this.participants;
        synchronized (map) {
            this.participants.remove(p);
            this.participants.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CreationResult create(CoordinatorImpl owner, String name, long timeout) {
        long id = this.ctr.incrementAndGet();
        CreationResult result = CoordinationImpl.create(owner, id, name, timeout);
        Map<Long, CoordinationImpl> map = this.coordinations;
        synchronized (map) {
            this.coordinations.put(id, result.coordination);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(CoordinationImpl c, boolean removeFromThread) {
        Stack<CoordinationImpl> stack;
        Map<Long, CoordinationImpl> map = this.coordinations;
        synchronized (map) {
            this.coordinations.remove(c.getId());
        }
        if (removeFromThread && (stack = this.getThreadStack(false)) != null) {
            stack.remove(c);
        }
    }

    void push(CoordinationImpl c) {
        Stack<CoordinationImpl> stack = this.getThreadStack(true);
        if (stack != null) {
            if (stack.contains(c)) {
                throw new CoordinationException("Coordination already pushed", c, 5);
            }
            c.setAssociatedThread(Thread.currentThread());
            stack.push(c);
        }
    }

    Coordination pop() {
        Stack<CoordinationImpl> stack = this.getThreadStack(false);
        if (stack != null && !stack.isEmpty()) {
            CoordinationImpl c = stack.pop();
            if (c != null) {
                c.setAssociatedThread(null);
            }
            return c;
        }
        return null;
    }

    Coordination peek() {
        Stack<CoordinationImpl> stack = this.getThreadStack(false);
        if (stack != null && !stack.isEmpty()) {
            return stack.peek();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Coordination> getCoordinations() {
        ArrayList<Coordination> result = new ArrayList<Coordination>();
        Map<Long, CoordinationImpl> map = this.coordinations;
        synchronized (map) {
            for (CoordinationImpl c : this.coordinations.values()) {
                result.add(c.getHolder());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Coordination getCoordinationById(long id) {
        Map<Long, CoordinationImpl> map = this.coordinations;
        synchronized (map) {
            CoordinationImpl c = this.coordinations.get(id);
            return c == null || c.isTerminated() ? null : c;
        }
    }

    public Coordination getEnclosingCoordination(CoordinationImpl c) {
        int index;
        Stack<CoordinationImpl> stack = this.getThreadStack(false);
        if (stack != null && (index = stack.indexOf(c)) > 0) {
            return (Coordination)stack.elementAt(index - 1);
        }
        return null;
    }

    public CoordinationException endNestedCoordinations(CoordinationImpl c) {
        int index;
        CoordinationException partiallyFailed = null;
        Stack<CoordinationImpl> stack = this.getThreadStack(false);
        if (stack != null && (index = stack.indexOf(c) + 1) > 0 && stack.size() > index) {
            int count = stack.size() - index;
            for (int i = 0; i < count; ++i) {
                CoordinationImpl nested = stack.pop();
                try {
                    if (partiallyFailed != null) {
                        nested.fail(partiallyFailed);
                    }
                    nested.end();
                    continue;
                }
                catch (CoordinationException ce) {
                    partiallyFailed = ce;
                }
            }
        }
        return partiallyFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Bundle owner) {
        ArrayList<CoordinationImpl> candidates = new ArrayList<CoordinationImpl>();
        Map<Long, CoordinationImpl> map = this.coordinations;
        synchronized (map) {
            for (Map.Entry<Long, CoordinationImpl> entry : this.coordinations.entrySet()) {
                CoordinationImpl c = entry.getValue();
                if (c.getBundle().getBundleId() != owner.getBundleId()) continue;
                candidates.add(c);
            }
        }
        if (candidates.size() > 0) {
            for (CoordinationImpl c : candidates) {
                if (!c.isTerminated()) {
                    c.fail(Coordination.RELEASED);
                    continue;
                }
                this.unregister(c, true);
            }
        }
    }

    public static final class CreationResult {
        public CoordinationImpl coordination;
        public CoordinationHolder holder;
    }
}

