/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.imap.api.display.ModifiedUtf7;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.DeniedAccessOnSharedMailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxConstants;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedRegex;
import org.apache.james.mailbox.model.search.Wildcard;

public interface PathConverter {
    public MailboxPath buildFullPath(String var1);

    public Optional<String> mailboxName(boolean var1, MailboxPath var2, MailboxSession var3);

    public MailboxQuery mailboxQuery(String var1, String var2, ImapSession var3);

    public static class Default
    implements PathConverter {
        private static final int NAMESPACE = 0;
        private static final int USER = 1;
        private final MailboxSession mailboxSession;
        private final Escaper usernameEscaper;

        private Default(MailboxSession mailboxSession) {
            this.mailboxSession = mailboxSession;
            this.usernameEscaper = Escapers.builder().addEscape(mailboxSession.getPathDelimiter(), "__").addEscape('_', "_-").build();
        }

        @Override
        public MailboxPath buildFullPath(String mailboxName) {
            if (Strings.isNullOrEmpty((String)mailboxName)) {
                return this.buildRelativePath("");
            }
            if (this.isAbsolute(mailboxName)) {
                return this.buildAbsolutePath(mailboxName);
            }
            return this.buildRelativePath(mailboxName);
        }

        private boolean isAbsolute(String mailboxName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mailboxName) ? 1 : 0) != 0);
            return mailboxName.charAt(0) == '#';
        }

        private MailboxPath buildRelativePath(String mailboxName) {
            return new MailboxPath("#private", this.mailboxSession.getUser(), this.sanitizeMailboxName(mailboxName));
        }

        private MailboxPath buildAbsolutePath(String absolutePath) {
            return this.asMailboxPath(Splitter.on((char)this.mailboxSession.getPathDelimiter()).omitEmptyStrings().splitToList((CharSequence)absolutePath), this.mailboxSession);
        }

        private MailboxPath asMailboxPath(List<String> mailboxPathParts, MailboxSession session) {
            String namespace = mailboxPathParts.get(0);
            if (namespace.equalsIgnoreCase("#private")) {
                String mailboxName = Joiner.on((char)session.getPathDelimiter()).join(Iterables.skip(mailboxPathParts, (int)1));
                return new MailboxPath("#private", session.getUser(), this.sanitizeMailboxName(mailboxName));
            }
            if (namespace.equalsIgnoreCase("#user")) {
                if (mailboxPathParts.size() == 1) {
                    String mailboxName = Joiner.on((char)session.getPathDelimiter()).join(Iterables.skip(mailboxPathParts, (int)1));
                    return new MailboxPath("#private", null, this.sanitizeMailboxName(mailboxName));
                }
                String username = mailboxPathParts.get(1);
                String unescapedUsername = username.replace("__", String.valueOf(MailboxConstants.FOLDER_DELIMITER)).replace("_-", "_");
                Username user = Username.from((String)unescapedUsername, session.getUser().getDomainPart().map(Domain::asString));
                String mailboxName = Joiner.on((char)session.getPathDelimiter()).join(Iterables.skip(mailboxPathParts, (int)2));
                return new MailboxPath("#private", user, this.sanitizeMailboxName(mailboxName));
            }
            throw new DeniedAccessOnSharedMailboxException();
        }

        private String sanitizeMailboxName(String mailboxName) {
            if (mailboxName.equalsIgnoreCase("INBOX")) {
                return "INBOX";
            }
            return mailboxName;
        }

        private String joinMailboxPath(MailboxPath mailboxPath, MailboxSession session) {
            StringBuilder sb = new StringBuilder();
            if (mailboxPath.getNamespace() != null && !mailboxPath.getNamespace().isEmpty()) {
                if (mailboxPath.getNamespace().equalsIgnoreCase("#private") && !mailboxPath.belongsTo(session)) {
                    sb.append("#user");
                } else {
                    sb.append(mailboxPath.getNamespace());
                }
            }
            if (mailboxPath.getUser() != null && !mailboxPath.belongsTo(session)) {
                if (!sb.isEmpty()) {
                    sb.append(session.getPathDelimiter());
                }
                sb.append(this.usernameEscaper.escape(mailboxPath.getUser().getLocalPart()));
            }
            if (mailboxPath.getName() != null && !mailboxPath.getName().isEmpty()) {
                if (!sb.isEmpty()) {
                    sb.append(session.getPathDelimiter());
                }
                sb.append(mailboxPath.getName());
            }
            return sb.toString();
        }

        @Override
        public Optional<String> mailboxName(boolean relative, MailboxPath path, MailboxSession session) {
            if (relative && path.belongsTo(session)) {
                return Optional.of(path.getName());
            }
            return Optional.of(this.joinMailboxPath(path, session));
        }

        @Override
        public MailboxQuery mailboxQuery(String finalReferencename, String mailboxName, ImapSession session) {
            MailboxSession mailboxSession = session.getMailboxSession();
            String decodedMailboxName = ModifiedUtf7.decodeModifiedUTF7(mailboxName);
            if (finalReferencename.isEmpty()) {
                if (mailboxName.equals("*")) {
                    return MailboxQuery.builder().matchesAllMailboxNames().build();
                }
                int delimiterPosition = mailboxName.indexOf(mailboxSession.getPathDelimiter());
                if (mailboxName.startsWith("#") && delimiterPosition > 0 && delimiterPosition + 1 < mailboxName.length()) {
                    return this.mailboxQuery(mailboxName.substring(0, delimiterPosition), mailboxName.substring(delimiterPosition + 1), session);
                }
                return MailboxQuery.builder().expression((MailboxNameExpression)new PrefixedRegex("", decodedMailboxName, mailboxSession.getPathDelimiter())).build();
            }
            MailboxPath basePath = this.computeBasePath(session, finalReferencename);
            if (basePath.getNamespace().equals("#private") && basePath.getUser() == null) {
                int separatorPosition = decodedMailboxName.indexOf(mailboxSession.getPathDelimiter());
                if (separatorPosition >= 0) {
                    Username username = Username.of((String)decodedMailboxName.substring(0, separatorPosition));
                    return MailboxQuery.builder().namespace("#private").username(username).expression((MailboxNameExpression)new PrefixedRegex(basePath.getName(), decodedMailboxName.substring(separatorPosition + 1), mailboxSession.getPathDelimiter())).build();
                }
                return MailboxQuery.builder().namespace("#private").expression((MailboxNameExpression)new PrefixedRegex(basePath.getName(), decodedMailboxName, mailboxSession.getPathDelimiter())).build();
            }
            if (basePath.getNamespace().equals("#private") && basePath.getUser().equals((Object)mailboxSession.getUser()) && basePath.getName().isEmpty() && mailboxName.equals("*")) {
                return MailboxQuery.builder().userAndNamespaceFrom(basePath).expression((MailboxNameExpression)Wildcard.INSTANCE).build();
            }
            return MailboxQuery.builder().userAndNamespaceFrom(basePath).expression((MailboxNameExpression)new PrefixedRegex(basePath.getName(), decodedMailboxName, mailboxSession.getPathDelimiter())).build();
        }

        private MailboxPath computeBasePath(ImapSession session, String finalReferencename) {
            boolean isRelative;
            String decodedName = ModifiedUtf7.decodeModifiedUTF7(finalReferencename);
            boolean bl = isRelative = !finalReferencename.startsWith("#");
            if (isRelative) {
                return MailboxPath.forUser((Username)session.getUserName(), (String)decodedName);
            }
            return this.buildFullPath(decodedName);
        }
    }

    public static interface Factory {
        public static final Factory DEFAULT = new Default();

        public PathConverter forSession(ImapSession var1);

        public PathConverter forSession(MailboxSession var1);

        public static class Default
        implements Factory {
            @Override
            public PathConverter forSession(ImapSession session) {
                return new org.apache.james.imap.main.PathConverter$Default(session.getMailboxSession());
            }

            @Override
            public PathConverter forSession(MailboxSession session) {
                return new org.apache.james.imap.main.PathConverter$Default(session);
            }
        }
    }
}

