/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.DelegatingMetaDataFactory;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;

public class MetaDataPlusMappingFactory
extends DelegatingMetaDataFactory {
    private final MetaDataFactory _map;

    public MetaDataPlusMappingFactory(MetaDataFactory meta, MetaDataFactory map) {
        this(meta, map, null);
    }

    public MetaDataPlusMappingFactory(MetaDataFactory meta, MetaDataFactory map, OpenJPAConfiguration conf) {
        super(meta);
        this._map = map;
        if (conf.getCompatibilityInstance().getMetaFactoriesAreStrict()) {
            meta.setStrict(true);
            map.setStrict(true);
        }
    }

    public MetaDataFactory getMappingDelegate() {
        return this._map;
    }

    public MetaDataFactory getInnermostMappingDelegate() {
        if (this._map instanceof DelegatingMetaDataFactory) {
            return ((DelegatingMetaDataFactory)this._map).getInnermostDelegate();
        }
        return this._map;
    }

    @Override
    public void setRepository(MetaDataRepository repos) {
        super.setRepository(repos);
        this._map.setRepository(repos);
    }

    @Override
    public void setStoreDirectory(File dir) {
        super.setStoreDirectory(dir);
        this._map.setStoreDirectory(dir);
    }

    @Override
    public void setStoreMode(int store) {
        super.setStoreMode(store);
        this._map.setStoreMode(store);
    }

    @Override
    public void setStrict(boolean strict) {
    }

    @Override
    public void load(Class cls, int mode, ClassLoader envLoader) {
        if ((mode & 0xFFFFFFFD) != 0) {
            super.load(cls, mode & 0xFFFFFFFD, envLoader);
        }
        if (cls != null && (mode & 2) != 0) {
            this._map.load(cls, mode & 0xFFFFFFFE, envLoader);
        }
    }

    @Override
    public boolean store(ClassMetaData[] metas, QueryMetaData[] queries, SequenceMetaData[] seqs, int mode, Map output) {
        boolean store = true;
        if ((mode & 0xFFFFFFFD) != 0) {
            store &= super.store(metas, queries, seqs, mode & 0xFFFFFFFD, output);
        }
        if ((mode & 2) != 0) {
            store &= this._map.store(metas, queries, seqs, mode & 0xFFFFFFFE, output);
        }
        return store;
    }

    @Override
    public boolean drop(Class[] cls, int mode, ClassLoader envLoader) {
        boolean drop = true;
        if ((mode & 0xFFFFFFFD) != 0) {
            drop &= super.drop(cls, mode & 0xFFFFFFFD, envLoader);
        }
        if ((mode & 2) != 0) {
            drop &= this._map.drop(cls, mode & 0xFFFFFFFE, envLoader);
        }
        return drop;
    }

    @Override
    public Set getPersistentTypeNames(boolean classpath, ClassLoader envLoader) {
        Set names = super.getPersistentTypeNames(classpath, envLoader);
        if (names != null && !names.isEmpty()) {
            return names;
        }
        return this._map.getPersistentTypeNames(classpath, envLoader);
    }

    @Override
    public void clear() {
        super.clear();
        this._map.clear();
    }

    @Override
    public void addClassExtensionKeys(Collection exts) {
        super.addClassExtensionKeys(exts);
        this._map.addClassExtensionKeys(exts);
    }

    @Override
    public void addFieldExtensionKeys(Collection exts) {
        super.addFieldExtensionKeys(exts);
        this._map.addFieldExtensionKeys(exts);
    }
}

