/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MailImpl;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.james.transport.mailets.jsieve.VacationReply;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.optional.ActionVacation;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VacationAction
implements MailAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(VacationAction.class);

    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        ActionVacation actionVacation = (ActionVacation)action;
        int dayDifference = Long.valueOf(ChronoUnit.DAYS.between(context.getScriptActivationDate().toLocalDate(), context.getScriptInterpretationDate().toLocalDate())).intValue();
        if (this.isStillInVacation(actionVacation, dayDifference) && this.isValidForReply(mail, actionVacation, context) && !this.isMailingList(mail)) {
            this.sendVacationNotification(mail, actionVacation, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVacationNotification(Mail mail, ActionVacation actionVacation, ActionContext context) throws MessagingException {
        VacationReply vacationReply = VacationReply.builder(mail, context).from(actionVacation.getFrom()).mime(actionVacation.getMime()).reason(actionVacation.getReason()).subject(actionVacation.getSubject()).build();
        MailImpl replyMail = MailImpl.builder().name(MailImpl.getId()).sender(vacationReply.getSender()).addRecipients(vacationReply.getRecipients()).mimeMessage(vacationReply.getMimeMessage()).build();
        try {
            context.post((Mail)replyMail);
        }
        finally {
            LifecycleUtil.dispose((Object)replyMail);
        }
    }

    private boolean isStillInVacation(ActionVacation actionVacation, int dayDifference) {
        return dayDifference >= 0 && dayDifference <= actionVacation.getDuration();
    }

    private boolean isValidForReply(Mail mail, ActionVacation actionVacation, ActionContext context) {
        Set allowedMailAddresses;
        ImmutableSet currentMailAddresses = ImmutableSet.copyOf((Collection)mail.getRecipients());
        return !Sets.intersection((Set)currentMailAddresses, (Set)(allowedMailAddresses = (Set)Stream.concat(actionVacation.getAddresses().stream().flatMap(this::retrieveAddressFromString), Stream.of(context.getRecipient())).collect(ImmutableSet.toImmutableSet()))).isEmpty();
    }

    private Stream<MailAddress> retrieveAddressFromString(String address) {
        try {
            return Stream.of(new MailAddress(address));
        }
        catch (AddressException e) {
            LOGGER.warn("Mail address {} was not well formatted : {}", (Object)address, (Object)e.getLocalizedMessage());
            return Stream.empty();
        }
    }

    private boolean isMailingList(Mail mail) throws MessagingException {
        Enumeration enumeration = mail.getMessage().getAllHeaderLines();
        while (enumeration.hasMoreElements()) {
            String headerName = (String)enumeration.nextElement();
            if (!headerName.startsWith("List-")) continue;
            return true;
        }
        return false;
    }
}

