/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.FieldComparatorBase;
import org.apache.jackrabbit.core.query.lucene.FieldComparatorDecorator;
import org.apache.jackrabbit.core.query.lucene.FilterMultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.Ordering;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;

public class SortedMultiColumnQueryHits
extends FilterMultiColumnQueryHits {
    private final Iterator<ScoreNode[]> it;

    public SortedMultiColumnQueryHits(MultiColumnQueryHits hits, Ordering[] orderings, IndexReader reader) throws IOException {
        super(hits);
        ScoreNode[] next;
        ArrayList<ScoreNode[]> sortedHits = new ArrayList<ScoreNode[]>();
        while ((next = hits.nextScoreNodes()) != null) {
            sortedHits.add(next);
        }
        try {
            Collections.sort(sortedHits, new ScoreNodeComparator(reader, orderings, hits.getSelectorNames(), sortedHits.size()));
        }
        catch (RuntimeException e) {
            throw Util.createIOException(e);
        }
        this.it = sortedHits.iterator();
    }

    @Override
    public ScoreNode[] nextScoreNodes() throws IOException {
        if (this.it.hasNext()) {
            return this.it.next();
        }
        return null;
    }

    @Override
    public void skip(int n) throws IOException {
        while (n-- > 0) {
            this.nextScoreNodes();
        }
    }

    private static final class ScoreNodeComparator
    implements Comparator<ScoreNode[]> {
        private final IndexReader reader;
        private final Ordering[] orderings;
        private final int[] idx;
        private final ScoreDocComparator[] comparators;
        private final boolean[] isReverse;
        private final ScoreDoc doc1 = new ScoreDoc(0, 1.0f);
        private final ScoreDoc doc2 = new ScoreDoc(0, 1.0f);

        private ScoreNodeComparator(IndexReader reader, Ordering[] orderings, Name[] selectorNames, int numHits) throws IOException {
            this.reader = reader;
            this.orderings = orderings;
            List<Name> names = Arrays.asList(selectorNames);
            this.idx = new int[orderings.length];
            this.comparators = new ScoreDocComparator[orderings.length];
            this.isReverse = new boolean[orderings.length];
            for (int i = 0; i < orderings.length; ++i) {
                this.idx[i] = names.indexOf(orderings[i].getSelectorName());
                SortField sf = orderings[i].getSortField();
                if (sf.getComparatorSource() != null) {
                    FieldComparator c = sf.getComparatorSource().newComparator(sf.getField(), numHits, 0, false);
                    assert (c instanceof FieldComparatorBase);
                    this.comparators[i] = new ScoreDocComparator((FieldComparatorBase)c);
                    this.comparators[i].setNextReader(reader, 0);
                }
                this.isReverse[i] = sf.getReverse();
            }
        }

        @Override
        public int compare(ScoreNode[] sn1, ScoreNode[] sn2) {
            for (int i = 0; i < this.orderings.length; ++i) {
                int c;
                int scoreNodeIndex = this.idx[i];
                ScoreNode n1 = sn1[scoreNodeIndex];
                ScoreNode n2 = sn2[scoreNodeIndex];
                if (n1 == n2) continue;
                if (n1 == null) {
                    c = -1;
                } else if (n2 == null) {
                    c = 1;
                } else if (this.comparators[i] != null) {
                    try {
                        this.doc1.doc = n1.getDoc(this.reader);
                        this.doc1.score = n1.getScore();
                        this.doc2.doc = n2.getDoc(this.reader);
                        this.doc2.score = n2.getScore();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    c = this.comparators[i].compareDocs(this.doc1.doc, this.doc2.doc);
                } else {
                    c = new Float(n1.getScore()).compareTo(Float.valueOf(n2.getScore()));
                }
                if (c == 0) continue;
                if (this.isReverse[i]) {
                    c = -c;
                }
                return c;
            }
            return 0;
        }
    }

    private static final class ScoreDocComparator
    extends FieldComparatorDecorator {
        public ScoreDocComparator(FieldComparatorBase base) {
            super(base);
        }

        public int compareDocs(int doc1, int doc2) {
            return this.compare(this.sortValue(doc1), this.sortValue(doc2));
        }
    }
}

