/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jca;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.resource.spi.ConnectionRequestInfo;

public final class JCAConnectionRequestInfo
implements ConnectionRequestInfo {
    private final Credentials creds;
    private final String workspace;

    public JCAConnectionRequestInfo(JCAConnectionRequestInfo cri) {
        this(cri.creds, cri.workspace);
    }

    public JCAConnectionRequestInfo(Credentials creds, String workspace) {
        this.creds = creds;
        this.workspace = workspace;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public Credentials getCredentials() {
        return this.creds;
    }

    public int hashCode() {
        int hash1 = this.workspace != null ? this.workspace.hashCode() : 0;
        int hash2 = this.creds != null ? this.computeCredsHashCode(this.creds) : 0;
        return hash1 ^ hash2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JCAConnectionRequestInfo) {
            return this.equals((JCAConnectionRequestInfo)o);
        }
        return false;
    }

    private boolean equals(JCAConnectionRequestInfo o) {
        return this.equals(this.workspace, o.workspace) && this.equals(this.creds, o.creds);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    private boolean equals(char[] o1, char[] o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 != null) {
            return this.equals(new String(o1), new String(o2));
        }
        return false;
    }

    private boolean equals(Credentials o1, Credentials o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null && o2 != null) {
            if (o1 instanceof SimpleCredentials && o2 instanceof SimpleCredentials) {
                return this.equals((SimpleCredentials)o1, (SimpleCredentials)o2);
            }
            return o1.equals(o2);
        }
        return false;
    }

    private boolean equals(SimpleCredentials o1, SimpleCredentials o2) {
        if (!this.equals(o1.getUserID(), o2.getUserID())) {
            return false;
        }
        if (!this.equals(o1.getPassword(), o2.getPassword())) {
            return false;
        }
        Map<String, Object> m1 = this.getAttributeMap(o1);
        Map<String, Object> m2 = this.getAttributeMap(o2);
        return m1.equals(m2);
    }

    private Map<String, Object> getAttributeMap(SimpleCredentials creds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] keys = creds.getAttributeNames();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], creds.getAttribute(keys[i]));
        }
        return map;
    }

    private int computeCredsHashCode(Credentials c) {
        if (c instanceof SimpleCredentials) {
            return this.computeSimpleCredsHashCode((SimpleCredentials)c);
        }
        return c.hashCode();
    }

    private int computeSimpleCredsHashCode(SimpleCredentials c) {
        String userID = c.getUserID();
        char[] password = c.getPassword();
        Map<String, Object> m = this.getAttributeMap(c);
        int prime = 31;
        int result = 1;
        result = 31 * result + (userID == null ? 0 : userID.hashCode());
        for (int i = 0; i < password.length; ++i) {
            result = 31 * result + password[i];
        }
        result = 31 * result + (m == null ? 0 : m.hashCode());
        return result;
    }

    public String toString() {
        return "workspace (" + this.workspace + ") creds (" + String.valueOf(this.creds) + ")";
    }
}

